/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.dominate;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import dalvik.system.DexClassLoader;
import dc.android.common.BridgeContext;
import dc.common.Logger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class PluginLoadInstance {
    private static PluginLoadInstance ourInstance = new PluginLoadInstance();
    private Context ctx;
    private DexClassLoader classLoader;
    private Resources resources;
    private PackageInfo packageInfo;

    public static PluginLoadInstance getInstance() {
        return ourInstance;
    }

    private PluginLoadInstance() {
    }

    public void init(Context ctx, String pluginPath) {
        this.setContext(ctx);
        this.loadApk(pluginPath);
        if (BridgeContext.isDebug) {
            this.showInfo();
        }
    }

    public void setContext(Context ctx) {
        this.ctx = ctx.getApplicationContext();
    }

    public void loadApk(String dexPath) {
        Logger.w((Object[])new Object[]{this.getClass().getSimpleName(), dexPath});
        this.classLoader = new DexClassLoader(dexPath, this.ctx.getDir("dex", 0).getAbsolutePath(), null, this.ctx.getClassLoader());
        this.packageInfo = this.ctx.getPackageManager().getPackageArchiveInfo(dexPath, 1);
        AssetManager assetManager = null;
        try {
            assetManager = (AssetManager)AssetManager.class.newInstance();
            AssetManager.class.getDeclaredMethod("addAssetPath", String.class).invoke((Object)assetManager, dexPath);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        Logger.w((Object[])new Object[]{this.getClass().getSimpleName(), assetManager, this.ctx.getResources().getDisplayMetrics(), this.ctx.getResources().getConfiguration()});
        this.resources = new Resources(assetManager, this.ctx.getResources().getDisplayMetrics(), this.ctx.getResources().getConfiguration());
    }

    public DexClassLoader getDexClassLoader() {
        return this.classLoader;
    }

    public Resources getResources() {
        return this.resources;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public AssetManager getAssets() {
        return this.resources.getAssets();
    }

    public String getLauncherName() {
        return this.packageInfo.activities[0].name;
    }

    public void showInfo() {
        Logger.w((Object[])new Object[]{this.getClass().getSimpleName(), this.classLoader});
        for (ActivityInfo activityInfo : this.packageInfo.activities) {
            Logger.w((String)activityInfo.name);
        }
        try {
            for (String string : this.resources.getAssets().list("")) {
                Logger.w((String)string);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

