/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import dc.android.libs.permission.AbsPermissionCallback;
import dc.android.libs.permission.PermissionActivity;
import dc.android.libs.permission.PermissionCheckUtils;
import dc.android.libs.permission.PermissionFragment;

public class PermissionUtils {
    private AbsPermissionCallback cb;
    private String[] permissions;
    private Context ctx;
    private FragmentManager fragmentManager;

    public PermissionUtils(Context context) {
        this.ctx = context;
    }

    public PermissionUtils(@NonNull FragmentActivity activity) {
        this.fragmentManager = activity.getSupportFragmentManager();
        this.ctx = activity;
    }

    public PermissionUtils(@NonNull Fragment fragment) {
        this.fragmentManager = fragment.getChildFragmentManager();
        this.ctx = fragment.getContext();
    }

    public static PermissionUtils with(Context context) {
        PermissionUtils permisson = new PermissionUtils(context);
        return permisson;
    }

    public static PermissionUtils with(FragmentActivity activity) {
        PermissionUtils permisson = new PermissionUtils(activity);
        return permisson;
    }

    public static PermissionUtils with(Fragment fragment) {
        PermissionUtils permisson = new PermissionUtils(fragment);
        return permisson;
    }

    public PermissionUtils permisson(String permissons) {
        this.permissions = new String[]{permissons};
        return this;
    }

    public PermissionUtils permisson(String ... permissons) {
        this.permissions = permissons;
        return this;
    }

    public PermissionUtils callback(AbsPermissionCallback cb) {
        this.cb = cb;
        return this;
    }

    public void request() {
        if (this.permissions == null || this.permissions.length <= 0) {
            return;
        }
        if (null != this.ctx) {
            PermissionActivity.request(this.ctx, this.permissions, this.cb);
        } else if (null != this.fragmentManager) {
            PermissionFragment.request(this.fragmentManager, this.permissions, this.cb);
        }
    }

    public boolean check() {
        if (null == this.permissions || this.permissions.length <= 0) {
            return true;
        }
        if (null == this.ctx) {
            return false;
        }
        return PermissionCheckUtils.checkGrant(this.ctx, this.permissions, this.cb);
    }
}

