package dc.android.libs.permission;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import dc.android.common.activity.BaseActivity;

import static dc.android.common.BridgeContext.KEY_VAR_1;
import static dc.android.common.PermissionOpcode.REQ_PERMISSION;

/**
 * @author senrsl
 * @ClassName: PermissionActivity
 * @Package: dc.android.libs.permission
 * @CreateTime: 2019/8/16 11:45 AM
 */
public class PermissionActivity extends BaseActivity {
    private static AbsPermissionCallback cb;

    /*
     * 添加一个静态方法方便使用
     */
    public static void request(Context context, String[] permissions, AbsPermissionCallback callback) {

        if (PermissionProcessUtils.checkBlock(callback)) return;

        cb = callback;

        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(KEY_VAR_1, permissions);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = getIntent();
        if (!intent.hasExtra(KEY_VAR_1)) {
            return;
        }
        // 当api大于23时，才进行权限申请
        String[] permissions = getIntent().getStringArrayExtra(KEY_VAR_1);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            requestPermissions(permissions, REQ_PERMISSION);
        }
    }

    @TargetApi(Build.VERSION_CODES.M)
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (REQ_PERMISSION != requestCode) return;

        PermissionProcessUtils.showResult(getClass().getSimpleName(), permissions, grantResults);
        //PermissionActivity	android.permission.ACCESS_FINE_LOCATION	android.permission.CAMERA	-1	-1  都不同意
        //PermissionActivity	android.permission.ACCESS_FINE_LOCATION	android.permission.CAMERA	-1	0   同意第二个
        //PermissionActivity	android.permission.ACCESS_FINE_LOCATION	android.permission.CAMERA	-1	0   继续不同意第一个
        // 处理申请结果
        boolean[] shouldShowRequestPermissionRationale = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            shouldShowRequestPermissionRationale[i] = shouldShowRequestPermissionRationale(permissions[i]);
        }
        PermissionProcessUtils.onRequestPermissionsResult(permissions, grantResults, shouldShowRequestPermissionRationale, cb);

        finish();
    }


}
