package dc.android.libs;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import dc.android.libs.permission.AbsPermissionCallback;
import dc.android.libs.permission.PermissionActivity;
import dc.android.libs.permission.PermissionCheckUtils;
import dc.android.libs.permission.PermissionFragment;

/**
 * @author senrsl
 * @ClassName: PermissionUtils
 * @Package: dc.android.libs.permission
 * @CreateTime: 2019/8/16 1:37 PM
 */
public class PermissionUtils {

    // 权限申请回调
    private AbsPermissionCallback cb;
    // 需要申请的权限
    private String[] permissions;
    private Context ctx;

    private FragmentManager fragmentManager;

    public PermissionUtils(Context context) {
        this.ctx = context;
    }

    public PermissionUtils(@NonNull FragmentActivity activity) {
        fragmentManager = activity.getSupportFragmentManager();
        ctx = activity;
    }

    public PermissionUtils(@NonNull Fragment fragment) {
        fragmentManager = fragment.getChildFragmentManager();
        ctx = fragment.getContext();
    }


    //------------- with

    public static PermissionUtils with(Context context) {
        PermissionUtils permisson = new PermissionUtils(context);
        return permisson;
    }

    public static PermissionUtils with(FragmentActivity activity) {
        PermissionUtils permisson = new PermissionUtils(activity);
        return permisson;
    }

    public static PermissionUtils with(Fragment fragment) {
        PermissionUtils permisson = new PermissionUtils(fragment);
        return permisson;
    }

    //------------- other

    public PermissionUtils permisson(String permissons) {
        this.permissions = new String[]{permissons};
        return this;
    }

    public PermissionUtils permisson(String... permissons) {
        this.permissions = permissons;
        return this;
    }

    public PermissionUtils callback(AbsPermissionCallback cb) {
        this.cb = cb;
        return this;
    }

    //------------- call

    //请求权限授予
    public void request() {
        if (permissions == null || permissions.length <= 0) return;
        if (null != ctx) PermissionActivity.request(ctx, permissions, cb);
        else if (null != fragmentManager) PermissionFragment.request(fragmentManager, permissions, cb);
    }

    //检查权限授予
    public boolean check() {
        if (null == permissions || permissions.length <= 0) return true;
        if (null == ctx) return false;
        return PermissionCheckUtils.checkGrant(ctx, permissions, cb);
    }

}
