/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.permission;

import android.os.Build;
import dc.android.common.BridgeContext;
import dc.android.libs.permission.AbsPermissionCallback;
import dc.common.Logger;
import java.util.ArrayList;

class PermissionProcessUtils {
    PermissionProcessUtils() {
    }

    static void showResult(String tag, String[] permissions, int[] grantResults) {
        if (BridgeContext.isReport) {
            return;
        }
        StringBuffer sb = new StringBuffer(tag);
        for (String permision : permissions) {
            sb.append(BridgeContext.TAB);
            sb.append(permision);
        }
        for (int result : grantResults) {
            sb.append(BridgeContext.TAB);
            sb.append(result);
        }
        Logger.w((String)sb.toString());
    }

    static void onRequestPermissionsResult(String[] permissions, int[] grantResults, boolean[] shouldShowRequestPermissionRationale, AbsPermissionCallback cb) {
        ArrayList<String> listGrant = new ArrayList<String>();
        ArrayList<String> listDenied = new ArrayList<String>();
        ArrayList<String> listRationale = new ArrayList<String>();
        int length = permissions.length;
        for (int i = 0; i < length; ++i) {
            if (grantResults[i] != 0) {
                if (shouldShowRequestPermissionRationale[i]) {
                    listRationale.add(permissions[i]);
                    continue;
                }
                listDenied.add(permissions[i]);
                continue;
            }
            listGrant.add(permissions[i]);
        }
        cb.setList(listGrant, listDenied, listRationale);
        cb.onResult(listGrant.size() == length, !listDenied.isEmpty(), !listRationale.isEmpty());
    }

    static boolean isNeedRequest() {
        return Build.VERSION.SDK_INT >= 23;
    }

    static boolean checkBlock(AbsPermissionCallback cb) {
        if (PermissionProcessUtils.isNeedRequest()) {
            return false;
        }
        cb.onResult(true, false, false);
        return true;
    }
}

