/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.permission;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import dc.android.libs.permission.AbsPermissionCallback;
import java.util.ArrayList;

public class PermissionCheckUtils {
    public static boolean checkGrant(@NonNull Context ctx, String[] permissions, @Nullable AbsPermissionCallback cb) {
        boolean isAllGrant;
        ArrayList<String> listGrant = new ArrayList<String>();
        ArrayList<String> listDenied = new ArrayList<String>();
        ArrayList<String> listRationale = new ArrayList<String>();
        block4: for (String permission : permissions) {
            switch (ContextCompat.checkSelfPermission((Context)ctx, (String)permission)) {
                case 0: {
                    listGrant.add(permission);
                    continue block4;
                }
                case -1: {
                    listDenied.add(permission);
                }
            }
        }
        boolean bl = isAllGrant = listGrant.size() == permissions.length;
        if (null != cb) {
            cb.setList(listGrant, listDenied, listRationale);
            cb.onResult(isAllGrant, !listDenied.isEmpty(), !listRationale.isEmpty());
        }
        return isAllGrant;
    }
}

