package dc.android.libs;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import dc.android.libs.permission.AbsPermissionCallback;
import dc.android.libs.permission.PermissionActivity;
import dc.android.libs.permission.PermissionFragment;

/**
 * @author senrsl
 * @ClassName: PermissionUtils
 * @Package: dc.android.libs.permission
 * @CreateTime: 2019/8/16 1:37 PM
 */
public class PermissionUtils {

    // 权限申请回调
    private AbsPermissionCallback cb;
    // 需要申请的权限
    private String[] permissions;
    private Context context;

    private FragmentManager fragmentManager;

    public PermissionUtils(Context context) {
        this.context = context;
    }

    public PermissionUtils(@NonNull FragmentActivity activity) {
        fragmentManager = activity.getSupportFragmentManager();
    }

    public PermissionUtils(@NonNull Fragment fragment) {
        fragmentManager = fragment.getChildFragmentManager();
    }

    public static PermissionUtils with(Context context) {
        PermissionUtils permisson = new PermissionUtils(context);
        return permisson;
    }

    public static PermissionUtils with(FragmentActivity activity) {
        PermissionUtils permisson = new PermissionUtils(activity);
        return permisson;
    }

    public static PermissionUtils with(Fragment fragment) {
        PermissionUtils permisson = new PermissionUtils(fragment);
        return permisson;
    }

    public PermissionUtils permisson(String[] permissons) {
        this.permissions = permissons;
        return this;
    }

    public PermissionUtils callback(AbsPermissionCallback cb) {
        this.cb = cb;
        return this;
    }

    public void request() {
        if (permissions == null || permissions.length <= 0) return;
        if (null != context) PermissionActivity.request(context, permissions, cb);
        else if (null != fragmentManager) PermissionFragment.request(fragmentManager, permissions, cb);
    }

}
