/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.permission;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import dc.android.common.activity.BaseActivity;
import dc.android.libs.permission.PermissionCallback;

public class PermissionActivity
extends BaseActivity {
    public static final String KEY_PERMISSIONS = "permissions";
    private static final int RC_REQUEST_PERMISSION = 100;
    private static PermissionCallback cb;

    public static void request(Context context, String[] permissions, PermissionCallback callback) {
        cb = callback;
        Intent intent = new Intent(context, PermissionActivity.class);
        intent.putExtra(KEY_PERMISSIONS, permissions);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        if (!intent.hasExtra(KEY_PERMISSIONS)) {
            return;
        }
        String[] permissions = this.getIntent().getStringArrayExtra(KEY_PERMISSIONS);
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestPermissions(permissions, 100);
        }
    }

    @TargetApi(value=23)
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode != 100) {
            return;
        }
        boolean[] shouldShowRequestPermissionRationale = new boolean[permissions.length];
        for (int i = 0; i < permissions.length; ++i) {
            shouldShowRequestPermissionRationale[i] = this.shouldShowRequestPermissionRationale(permissions[i]);
        }
        this.onRequestPermissionsResult(permissions, grantResults, shouldShowRequestPermissionRationale);
    }

    @TargetApi(value=23)
    void onRequestPermissionsResult(String[] permissions, int[] grantResults, boolean[] shouldShowRequestPermissionRationale) {
        int length = permissions.length;
        int granted = 0;
        for (int i = 0; i < length; ++i) {
            if (grantResults[i] != 0) {
                if (shouldShowRequestPermissionRationale[i]) {
                    cb.onShouldShowRationale(permissions[i]);
                    continue;
                }
                cb.onDenied(permissions[i]);
                continue;
            }
            ++granted;
        }
        if (granted == length) {
            cb.onGranted();
        }
        this.finish();
    }
}

