package dc.android.libs;

import android.content.Context;
import dc.android.libs.permission.PermissionActivity;
import dc.android.libs.permission.PermissionCallback;

/**
 * @author senrsl
 * @ClassName: PermissionUtils
 * @Package: dc.android.libs.permission
 * @CreateTime: 2019/8/16 1:37 PM
 */
public class PermissionUtils {

    // 权限申请回调
    private PermissionCallback callback;
    // 需要申请的权限
    private String[] permissions;
    private Context context;

    public PermissionUtils(Context context) {
        this.context = context;
    }

    public static PermissionUtils with(Context context) {
        PermissionUtils permisson = new PermissionUtils(context);
        return permisson;
    }

    public PermissionUtils permisson(String[] permissons) {
        this.permissions = permissons;
        return this;
    }

    public PermissionUtils callback(PermissionCallback callback) {
        this.callback = callback;
        return this;
    }

    public void request() {
        if (permissions == null || permissions.length <= 0) {
            return;
        }
        PermissionActivity.request(context, permissions, callback);
    }

}
