package dc.android.libs.browser.tbs;

import com.tencent.smtt.export.external.interfaces.WebResourceError;
import com.tencent.smtt.export.external.interfaces.WebResourceRequest;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;

import android.graphics.Bitmap;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: TbsWebViewClient
 * @Package: dc.android.libs.browser.tbs
 * @CreateTime: 2018/9/29 下午7:24
 */
public class TbsWebViewClient extends WebViewClient {

    private TextView tvTitle;
    private ProgressBar progressBar;

    public TbsWebViewClient(TextView textView, ProgressBar progressBar) {
        this.tvTitle = textView;
        this.progressBar = progressBar;
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Logger.w(url, view);
        return false;
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        if (null != progressBar) progressBar.setVisibility(View.INVISIBLE);
        super.onPageFinished(view, url);
        Logger.w(view.getTitle());
        if (null != tvTitle) tvTitle.setText(view.getTitle());
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (null != progressBar) progressBar.setVisibility(View.VISIBLE);
        super.onPageStarted(view, url, favicon);
    }

    @Override
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
    }
}
