package dc.android.libs.browser.tbs;

import com.tencent.smtt.export.external.interfaces.IX5WebChromeClient;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: TbsStandWebChromeClient
 * @Package: dc.android.libs.browser.tbs
 * @CreateTime: 2018/10/12 下午7:11
 */
public class TbsStandWebChromeClient extends WebChromeClient {

    private Context ctx;
    private WebView webView;
    private ProgressBar progressBar;


    public TbsStandWebChromeClient(Context ctx, WebView webView, ProgressBar progressBar) {
        this.ctx = ctx;
        this.webView = webView;
        this.progressBar = progressBar;
    }

    //    private IX5WebChromeClient.CustomViewCallback xCustomViewCallback;
    private FrameLayout video_fullView;// 全屏时视频加载view、
    private View xCustomView;
    private com.tencent.smtt.sdk.WebChromeClient xwebchromeclient = new com.tencent.smtt.sdk.WebChromeClient() {
        @Override
        public void onProgressChanged(com.tencent.smtt.sdk.WebView webView, int percent) {
            super.onProgressChanged(webView, percent);
            if (percent > 40) {
                webView.setVisibility(View.VISIBLE);
            }
        }

        // 拦截全屏调用的方法
        @Override
        public void onShowCustomView(View view, IX5WebChromeClient.CustomViewCallback callback) {
            super.onShowCustomView(view, callback);
            getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE);
            Logger.w("onShowCustomView----xCustomView:" + xCustomView);
            webView.setVisibility(View.INVISIBLE);
            // 如果一个视图已经存在，那么立刻终止并新建一个
            if (xCustomView != null) {
                callback.onCustomViewHidden();
                return;
            }
            view.setVisibility(View.VISIBLE);
            video_fullView = (FrameLayout) webView.getParent();
            video_fullView.addView(view);
            xCustomView = view;
            xCustomView.setVisibility(View.VISIBLE);
//            xCustomViewCallback = callback;
            video_fullView.setVisibility(View.VISIBLE);
        }

        @Override
        public void onHideCustomView() {
            super.onHideCustomView();
            Logger.w("onHideCustomView----xCustomView:" + xCustomView);
            if (xCustomView == null) {
                // 不是全屏播放状态
                return;
            }
            getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
            xCustomView.setVisibility(View.GONE);
            video_fullView.removeView(xCustomView);
            xCustomView = null;
            video_fullView.setVisibility(View.GONE);
//            xCustomViewCallback.onCustomViewHidden();
            webView.setVisibility(View.VISIBLE);
        }
    };

    /**
     * 判断是否是全屏
     *
     * @return
     */
    public boolean inCustomView() {
        return (xCustomView != null);
    }

    /**
     * 全屏时按返加键执行退出全屏方法
     */
    public void hideCustomView() {
        xwebchromeclient.onHideCustomView();
        getActivity().setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
    }

    private Activity getActivity() {
        return ((Activity) ctx);
    }
}
