/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.browser.tbs;

import android.app.Activity;
import android.content.Context;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.tencent.smtt.export.external.interfaces.IX5WebChromeClient;
import com.tencent.smtt.export.external.interfaces.JsResult;
import com.tencent.smtt.sdk.WebChromeClient;
import com.tencent.smtt.sdk.WebView;
import com.tencent.smtt.sdk.WebViewClient;
import dc.android.libs.browser.R;
import dc.common.Logger;
import java.util.ArrayList;
import java.util.List;

public class TbsWebChromeClient
extends WebChromeClient {
    private Context ctx;
    private ProgressBar progressBar;
    View myVideoView;
    View myNormalView;
    IX5WebChromeClient.CustomViewCallback callback;

    public TbsWebChromeClient(Context ctx, ProgressBar progressBar) {
        this.ctx = ctx;
        this.progressBar = progressBar;
    }

    public boolean onJsConfirm(WebView arg0, String arg1, String arg2, JsResult arg3) {
        return super.onJsConfirm(arg0, arg1, arg2, arg3);
    }

    public void onShowCustomView(View view, IX5WebChromeClient.CustomViewCallback customViewCallback) {
        this.hideExt(view);
        FrameLayout normalView = (FrameLayout)this.getActivity().findViewById(R.id.webview);
        ViewGroup viewGroup = (ViewGroup)normalView.getParent();
        viewGroup.removeView((View)normalView);
        viewGroup.addView(view);
        this.myVideoView = view;
        this.myNormalView = normalView;
        this.callback = customViewCallback;
        this.setStatusBarVisible(false);
    }

    public void onHideCustomView() {
        if (this.callback != null) {
            this.callback.onCustomViewHidden();
            this.callback = null;
        }
        if (this.myVideoView != null) {
            ViewGroup viewGroup = (ViewGroup)this.myVideoView.getParent();
            viewGroup.removeView(this.myVideoView);
            viewGroup.addView(this.myNormalView);
        }
        this.setStatusBarVisible(true);
    }

    private void hideExt(View view) {
        List<View> list = this.getAllChildViews(view);
        for (View v : list) {
            Logger.w((Object[])new Object[]{v});
            if (!(v instanceof TextView) || !this.ctx.getString(R.string.cache).equals(((TextView)v).getText())) continue;
            v.setVisibility(4);
        }
    }

    private List<View> getAllChildViews(View view) {
        ArrayList<View> list = new ArrayList<View>();
        if (view instanceof ViewGroup) {
            ViewGroup vp = (ViewGroup)view;
            for (int i = 0; i < vp.getChildCount(); ++i) {
                View child = vp.getChildAt(i);
                Logger.w((String)("tbsView:" + child.getClass().getName()));
                list.add(child);
                list.addAll(this.getAllChildViews(child));
            }
        }
        return list;
    }

    private void setStatusBarVisible(boolean show) {
        if (show) {
            int uiFlags = 256;
            this.getActivity().getWindow().getDecorView().setSystemUiVisibility(uiFlags |= 0x1000);
        } else {
            int uiFlags = 1284;
            this.getActivity().getWindow().getDecorView().setSystemUiVisibility(uiFlags |= 0x1000);
        }
    }

    private Activity getActivity() {
        return (Activity)this.ctx;
    }

    public boolean onJsAlert(WebView arg0, String arg1, String arg2, JsResult arg3) {
        return super.onJsAlert(null, arg1, arg2, arg3);
    }

    public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
        WebView newView = new WebView(view.getContext());
        newView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return false;
            }
        });
        WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
        transport.setWebView(view);
        resultMsg.sendToTarget();
        return true;
    }

    public void onProgressChanged(WebView view, int progress) {
        super.onProgressChanged(view, progress);
        if (null != this.progressBar) {
            this.progressBar.setProgress(progress);
        }
    }
}

