/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.browser.tbs;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.tencent.smtt.sdk.ValueCallback;
import com.tencent.smtt.sdk.WebSettings;
import dc.android.libs.browser.BaseBrowserFragment;
import dc.android.libs.browser.R;
import dc.android.libs.browser.tbs.TbsManagerImpl;
import dc.android.libs.browser.tbs.TbsWebView;
import dc.common.Logger;

public class TbsFragment
extends BaseBrowserFragment {
    private TbsWebView webView;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_web_tbs, container, false);
        return view;
    }

    protected void inflatView() {
        super.inflatView();
        this.webView = (TbsWebView)((Object)this.findView());
    }

    @Override
    protected void initData() {
        this.browserManager = new TbsManagerImpl();
        this.browserManager.init((Context)this.activity, this.tvTitle, this.progressBar, this.webView);
        super.initData();
    }

    @Override
    protected void load(String url) {
        this.webView.loadUrl(url);
    }

    @Override
    protected void reload() {
        this.webView.reload();
    }

    @Override
    public String getUri() {
        Logger.w((Object[])new Object[]{this.webView.getUrl(), this.webView.getOriginalUrl()});
        return this.webView.getUrl();
    }

    @Override
    public void setFontSize(int sizeLevel) {
        WebSettings.TextSize textSize;
        switch (sizeLevel) {
            case 0: {
                textSize = WebSettings.TextSize.SMALLER;
                break;
            }
            case 2: {
                textSize = WebSettings.TextSize.LARGER;
                break;
            }
            case 3: {
                textSize = WebSettings.TextSize.LARGEST;
                break;
            }
            default: {
                textSize = WebSettings.TextSize.NORMAL;
            }
        }
        this.webView.getSettings().setTextSize(textSize);
    }

    @Override
    public void evaluateJavascript(String function, String[] arrParam, final BaseBrowserFragment.ValueCallback<String> cb) {
        super.evaluateJavascript(function, arrParam, cb);
        StringBuffer sb = new StringBuffer("javascript:");
        sb.append(function);
        sb.append("(");
        for (int i = 0; i < arrParam.length; ++i) {
            sb.append(i > 0 ? "," : "").append("'").append(arrParam[i]).append("'");
        }
        sb.append(")");
        this.webView.evaluateJavascript(sb.toString(), (ValueCallback)new ValueCallback<String>(){

            public void onReceiveValue(String s) {
                cb.onReceiveValue(s);
            }
        });
    }
}

