/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.browser.blink;

import android.content.Context;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.android.base.domain.KeyValueBean;
import dc.android.libs.browser.BaseBrowserManager;
import dc.android.libs.browser.BaseJavascriptFunction;
import dc.android.libs.browser.BrowserContext;
import dc.android.libs.browser.IBaseBrowserManager;
import dc.android.libs.browser.blink.BlinkWebChromeClient;
import dc.android.libs.browser.blink.BlinkWebView;
import dc.android.libs.browser.blink.BlinkWebViewClient;
import dc.android.libs.browser.blink.IBlinkManager;
import dc.common.Logger;
import java.util.List;

public class BlinkManagerImpl<T extends BlinkWebView>
extends BaseBrowserManager
implements IBlinkManager<T> {
    private BlinkWebView webView;

    @Override
    public void init(Context ctx, TextView tvTitle, ProgressBar progressBar, T webView) {
        super.init(ctx, tvTitle, progressBar);
        this.webView = webView;
    }

    @Override
    public void initSettings() {
        this.webView.initSettings();
        this.webView.addAgent(BrowserContext.BROWSER_AGENT);
        this.webView.setWebChromeClient(new BlinkWebChromeClient(this.ctx, this.webView, this.progressBar));
        this.webView.setWebViewClient(new BlinkWebViewClient(this.tvTitle, this.progressBar));
        this.webView.setOnLongClickListener(this.listenerClickLong);
    }

    @Override
    public void setJavascript(BaseJavascriptFunction function, String exploreName) {
        this.webView.addJavascriptInterface(function, exploreName);
    }

    @Override
    public void syncCookie(List<KeyValueBean> list) {
        if (null == list || list.isEmpty()) {
            return;
        }
        try {
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            for (KeyValueBean bean : list) {
                Logger.w((String)(bean.getKey() + "   " + bean.getValue()));
                cookieManager.setCookie(bean.getKey(), bean.getValue());
            }
            if (Build.VERSION.SDK_INT >= 21) {
                cookieManager.flush();
            } else {
                CookieSyncManager.createInstance((Context)this.ctx.getApplicationContext());
                CookieSyncManager.getInstance().sync();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reload() {
        this.webView.reload();
    }

    @Override
    public boolean back() {
        if (!this.webView.canGoBack()) {
            return false;
        }
        this.webView.goBack();
        return true;
    }

    @Override
    public void destroy() {
        if (null == this.webView) {
            return;
        }
        this.webView.stopLoading();
        this.webView.destroy();
    }

    @Override
    public void setLongClickCallback(IBaseBrowserManager.LongClickCallback cb) {
        this.cbLong = cb;
    }

    @Override
    protected boolean clickLong() {
        WebView.HitTestResult result = this.webView.getHitTestResult();
        if (result.getType() == 5) {
            String uri = result.getExtra();
            if (null != this.cbLong) {
                this.cbLong.onProcess(uri);
            }
        }
        return super.clickLong();
    }
}

