package dc.android.libs.browser.tbs;

import java.util.List;

import dc.android.libs.browser.BaseBrowserManager;
import com.tencent.smtt.sdk.CookieManager;
import com.tencent.smtt.sdk.CookieSyncManager;

import dc.android.base.domain.KeyValueBean;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: BaseTbsManagerImpl
 * @Package: dc.android.libs.browser.tbs
 * @CreateTime: 2018/12/3 6:29 PM
 */
public class BaseTbsManagerImpl extends BaseBrowserManager {


    public void syncTbsCookie(List<KeyValueBean> list) {
        if (null == list || list.isEmpty()) return;
        try {
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            for (KeyValueBean bean : list) {
                Logger.w(bean.getKey() + "   " + bean.getValue());
                cookieManager.setCookie(bean.getKey(), bean.getValue());
            }
            CookieSyncManager.createInstance(ctx.getApplicationContext());
            CookieSyncManager.getInstance().sync();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
