package dc.android.libs.browser.blink;

import android.graphics.Bitmap;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: BlinkWebViewClient
 * @Package: dc.android.libs.browser.blink
 * @CreateTime: 2018/9/29 下午7:16
 */
public class BlinkWebViewClient extends WebViewClient {

    private TextView tvTitle;
    private ProgressBar progressBar;

    public BlinkWebViewClient(TextView tvTitle, ProgressBar progressBar) {
        this.tvTitle = tvTitle;
        this.progressBar = progressBar;
    }

    @Override
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        Logger.w(url, view);
        if (url.startsWith("intent") || url.startsWith("https://s-qncdn-live")) return true;
        return super.shouldOverrideUrlLoading(view, url);
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        if (null != progressBar) progressBar.setVisibility(View.INVISIBLE);
        super.onPageFinished(view, url);
        Logger.w(view.getTitle());
        if (null != tvTitle) tvTitle.setText(view.getTitle());
    }

    @Override
    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (null != progressBar) progressBar.setVisibility(View.VISIBLE);
        super.onPageStarted(view, url, favicon);
    }

    @Override
    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
    }
}
