package dc.android.libs.browser.blink;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.webkit.WebSettings;
import android.webkit.WebView;
import dc.android.common.BridgeContext;

/**
 * @author senrsl
 * @ClassName: BlinkWebView
 * @Package: dc.android.libs.browser.blink
 * @CreateTime: 2018/9/29 上午10:53
 */
public class BlinkWebView extends WebView {

    public BlinkWebView(Context context) {
        super(context);
    }

    public BlinkWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void initSettings() {
        WebSettings webSettings = getSettings();

        setVerticalScrollBarEnabled(false); //垂直不显示
        setHorizontalScrollBarEnabled(false);//水平滑动条不显示

        webSettings.setBuiltInZoomControls(true); // 显示放大缩小
        webSettings.setSupportZoom(true); // 可以缩放
        webSettings.setDisplayZoomControls(false);

        webSettings.setUseWideViewPort(true);//使用webview推荐的窗口
        webSettings.setLoadWithOverviewMode(true);//设置网页自适应屏幕大小 ---这个属性应该是跟上面一个属性一起用

        webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
        webSettings.setDefaultTextEncodingName(BridgeContext.ENCODE_UTF_8);

        webSettings.setDomStorageEnabled(true);//设置支持html5本地存储，有些h5页面服务器做了缓存，webview控件也要设置，否则显示不出来页面
        webSettings.setAllowFileAccess(true);// 设置可以访问缓存文件
        webSettings.setAppCacheEnabled(true);//应用可以有缓存

        webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NARROW_COLUMNS);//排版适应屏幕
        webSettings.setSupportMultipleWindows(false);//支持多窗口


        webSettings.setJavaScriptEnabled(true);//支持js
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);//支持window.open
        webSettings.setGeolocationEnabled(true);//HTML5的地理位置服务,设置为true,启用地理定位

        //webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);//提高网页渲染的优先级

        // webview从5.0开始默认不允许混合模式,https中不能加载http资源,需要设置开启
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP)
            webSettings.setMixedContentMode(WebSettings.MIXED_CONTENT_ALWAYS_ALLOW);

//        webSettings.setUserAgentString(webSettings.getUserAgentString() + "; candy;");
//        webView.addJavascriptInterface(new JsBridge(this), "dcBridge");、
//        webView.setWebChromeClient(webChromeClient);
//        webView.setWebViewClient(webViewClient);
//        webView.setOnLongClickListener(listenerClickLong);
    }

    public WebSettings getWebSettings() {
        return getSettings();
    }

    public void addAgent(String agent) {
        WebSettings webSettings = getSettings();
        webSettings.setUserAgentString(webSettings.getUserAgentString() + agent);
    }

    public void setAgent(String agent) {
        getSettings().setUserAgentString(agent);
    }


}
