package dc.android.libs.browser.blink;

import java.util.List;

import dc.android.libs.browser.BaseBrowserManager;
import dc.android.libs.browser.BaseJavascriptFunction;
import dc.android.libs.browser.BrowserContext;

import android.content.Context;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.widget.ProgressBar;
import android.widget.TextView;
import dc.android.base.domain.KeyValueBean;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: BlinkManager
 * @Package: dc.android.libs.browser.blink
 * @CreateTime: 2018/9/29 下午3:06
 */
public class BlinkManagerImpl<T extends BlinkWebView> extends BaseBrowserManager implements IBlinkManager<T> {


    private BlinkWebView webView;

    @Override
    public void init(Context ctx, TextView tvTitle, ProgressBar progressBar, T webView) {
        super.init(ctx, tvTitle, progressBar);
        this.webView = webView;
    }


    @Override
    public void initSettings() {
        webView.initSettings();

        webView.addAgent(BrowserContext.BROWSER_AGENT);
//        webView.addJavascriptInterface(new JavascriptFunction(ctx), Constants.BROWSER_JS_METHOD);
        webView.setWebChromeClient(new BlinkWebChromeClient(ctx, webView, progressBar));
        webView.setWebViewClient(new BlinkWebViewClient(tvTitle, progressBar));
        webView.setOnLongClickListener(listenerClickLong);
    }

    @Override
    public void setJavascript(BaseJavascriptFunction function, String exploreName) {
        webView.addJavascriptInterface(function, exploreName);
    }


//    @Override
//    public void openInBrowser(String uri) {
//        WebView.HitTestResult result = webView.getHitTestResult();
//        String data = result.getExtra();
//        super.openInBrowser(data);
//    }


    @Override
    public void syncCookie(List<KeyValueBean> list) {
        if (null == list || list.isEmpty()) return;
        try {
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.setAcceptCookie(true);
            for (KeyValueBean bean : list) {
                Logger.w(bean.getKey() + "   " + bean.getValue());
                cookieManager.setCookie(bean.getKey(), bean.getValue());
            }
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
                cookieManager.flush();
            } else {
                CookieSyncManager.createInstance(ctx.getApplicationContext());
                CookieSyncManager.getInstance().sync();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reload() {
        webView.reload();
    }

    @Override
    public boolean back() {
        if (webView.canGoBack())
            webView.goBack();
        else
            return false;
        return true;
    }

    @Override
    public void destroy() {
        if (null == webView) return;
        webView.stopLoading();
        webView.destroy();
    }

    @Override
    public void setLongClickCallback(LongClickCallback cb) {
        cbLong = cb;
    }

    @Override
    protected boolean clickLong() {
        // 长按事件监听（注意：需要实现LongClickCallBack接口并传入对象）
        WebView.HitTestResult result = webView.getHitTestResult();//获取所点击的内容
        if (result.getType() == WebView.HitTestResult.IMAGE_TYPE) {//判断被点击的类型为图片
            String uri = result.getExtra();
//            clickLong(uri);
            if (null != cbLong) cbLong.onProcess(uri);
        }
        return super.clickLong();
    }

}
