/*
 * Decompiled with CFR 0.152.
 */
package wgz.datatom.com.utillibrary.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static String FORMAT_Y = "yyyy";
    public static String FORMAT_HM = "HH:mm";
    public static String FORMAT_MDHM = "MM-dd HH:mm";
    public static String FORMAT_YMD = "yyyy-MM-dd";
    public static String FORMAT_YMDHM = "yyyy-MM-dd HH:mm";
    public static String FORMAT_YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static String FORMAT_FULL = "yyyy-MM-dd HH:mm:ss.S";
    public static String FORMAT_FULL_SN = "yyyyMMddHHmmssS";
    public static String FORMAT_YMD_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String FORMAT_YMDH_CN = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6";
    public static String FORMAT_YMDHM_CN = "yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206";
    public static String FORMAT_YMDHMS_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2";
    public static String FORMAT_FULL_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2SSS\u6beb\u79d2";
    public static Calendar calendar = null;
    private static final String FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static Date str2Date(String str) {
        return DateUtil.str2Date(str, null);
    }

    public static Date str2Date(String str, String format) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = FORMAT;
        }
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            date = sdf.parse(str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Calendar str2Calendar(String str) {
        return DateUtil.str2Calendar(str, null);
    }

    public static Calendar str2Calendar(String str, String format) {
        Date date = DateUtil.str2Date(str, format);
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static String date2Str(Calendar c) {
        return DateUtil.date2Str(c, null);
    }

    public static String date2Str(Calendar c, String format) {
        if (c == null) {
            return null;
        }
        return DateUtil.date2Str(c.getTime(), format);
    }

    public static String date2Str(Date d) {
        return DateUtil.date2Str(d, null);
    }

    public static String date2Str(Date d, String format) {
        if (d == null) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = FORMAT;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String s = sdf.format(d);
        return s;
    }

    public static String getCurDateStr() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        return c.get(1) + "-" + (c.get(2) + 1) + "-" + c.get(5) + "-" + c.get(11) + ":" + c.get(12) + ":" + c.get(13);
    }

    public static String getCurDateStr(String format) {
        Calendar c = Calendar.getInstance();
        return DateUtil.date2Str(c, format);
    }

    public static String getMillon(long time) {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(time);
    }

    public static String getDay(long time) {
        return new SimpleDateFormat("yyyy-MM-dd").format(time);
    }

    public static String getSMillon(long time) {
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS").format(time);
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static String getNextHour(String format, int h) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = new Date();
        date.setTime(date.getTime() + (long)(h * 60 * 60 * 1000));
        return sdf.format(date);
    }

    public static String getTimeString() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_FULL);
        Calendar calendar = Calendar.getInstance();
        return df.format(calendar.getTime());
    }

    public static int getMonth(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHour(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinute(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static String getDatePattern() {
        return FORMAT_YMDHMS;
    }

    public static int getSecond(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static Date parse(String strDate) {
        return DateUtil.parse(strDate, DateUtil.getDatePattern());
    }

    public static long getMillis(Date date) {
        calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    public static int countDays(String date) {
        long t = Calendar.getInstance().getTime().getTime();
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtil.parse(date));
        long t1 = c.getTime().getTime();
        return (int)(t / 1000L - t1 / 1000L) / 3600 / 24;
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int countDays(String date, String format) {
        long t = Calendar.getInstance().getTime().getTime();
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtil.parse(date, format));
        long t1 = c.getTime().getTime();
        return (int)(t / 1000L - t1 / 1000L) / 3600 / 24;
    }
}

