/*
 * Decompiled with CFR 0.152.
 */
package wgz.datatom.com.utillibrary;

import android.app.Activity;
import android.content.Context;
import java.util.Stack;

public class ActivityManager {
    private static Stack<Activity> activityStack;
    private static ActivityManager instance;

    public static ActivityManager getInstance() {
        return instance;
    }

    public void addActivity(Activity activity) {
        if (activityStack == null) {
            activityStack = new Stack();
        }
        activityStack.add(activity);
    }

    public Activity currentActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        return activity;
    }

    public void finishActivity() {
        Activity activity = (Activity)activityStack.lastElement();
        this.finishActivity(activity);
    }

    public void finishActivity(Activity activity) {
        if (activity != null) {
            activityStack.remove(activity);
            activity.finish();
            activity = null;
        }
    }

    public void finishActivity(Class<?> cls) {
        for (Activity activity : activityStack) {
            if (!activity.getClass().equals(cls)) continue;
            this.finishActivity(activity);
            return;
        }
    }

    public void finishAllActivity() {
        int size = activityStack.size();
        for (int i = 0; i < size; ++i) {
            if (null == activityStack.get(i)) continue;
            ((Activity)activityStack.get(i)).finish();
        }
        activityStack.clear();
    }

    public void AppExit(Context context) {
        try {
            this.finishAllActivity();
            android.app.ActivityManager activityMgr = (android.app.ActivityManager)context.getSystemService("activity");
            activityMgr.restartPackage(context.getPackageName());
            System.exit(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        instance = new ActivityManager();
    }
}

