/*
 * Decompiled with CFR 0.152.
 */
package ru.xpoft.vaadin.security;

import com.vaadin.navigator.NavigationStateManager;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import java.util.Arrays;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresGuest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.xpoft.vaadin.DiscoveryNavigator;

public class ShiroSecurityNavigator
extends DiscoveryNavigator {
    private static Logger logger = LoggerFactory.getLogger(ShiroSecurityNavigator.class);

    public ShiroSecurityNavigator(UI ui, ComponentContainer container) {
        super(ui, container);
    }

    public ShiroSecurityNavigator(UI ui, SingleComponentContainer container) {
        super(ui, container);
    }

    public ShiroSecurityNavigator(UI ui, ViewDisplay display) {
        super(ui, display);
    }

    public ShiroSecurityNavigator(UI ui, NavigationStateManager stateManager, ViewDisplay display) {
        super(ui, stateManager, display);
    }

    @Override
    protected void addCachedBeans() {
        for (DiscoveryNavigator.ViewCache view : views) {
            if (!ShiroSecurityNavigator.hasAccess(view.getClazz())) continue;
            logger.debug("view name: \"{}\", class: {}, viewCached: {}", new Object[]{view.getName(), view.getClazz(), view.isCached()});
            this.addBeanView(view.getName(), view.getBeanName(), view.getClazz(), view.isCached());
        }
    }

    @Override
    public void addBeanView(String viewName, Class<? extends View> viewClass, boolean cached) {
        if (!ShiroSecurityNavigator.hasAccess(viewClass)) {
            return;
        }
        super.addBeanView(viewName, viewClass, cached);
    }

    public static boolean hasAccess(Class<?> clazz) {
        Subject subject;
        Subject subject2;
        Logical logical;
        boolean isAllow = true;
        if (clazz.isAnnotationPresent(RequiresRoles.class)) {
            isAllow = false;
            RequiresRoles requiresRoles = clazz.getAnnotation(RequiresRoles.class);
            String[] roles = requiresRoles.value();
            logical = requiresRoles.logical();
            if (roles.length > 0) {
                subject2 = SecurityUtils.getSubject();
                if (!subject2.isAuthenticated()) {
                    return false;
                }
                if (logical == Logical.AND && subject2.hasAllRoles(Arrays.asList(roles))) {
                    isAllow = true;
                }
                if (logical == Logical.OR) {
                    for (boolean hasRole : subject2.hasRoles(Arrays.asList(roles))) {
                        if (!hasRole) continue;
                        isAllow = true;
                        break;
                    }
                }
            }
        }
        if (isAllow && clazz.isAnnotationPresent(RequiresPermissions.class)) {
            isAllow = false;
            RequiresPermissions requiresPermissions = clazz.getAnnotation(RequiresPermissions.class);
            String[] permissions = requiresPermissions.value();
            logical = requiresPermissions.logical();
            subject2 = SecurityUtils.getSubject();
            if (permissions.length > 0) {
                if (!subject2.isAuthenticated()) {
                    return false;
                }
                if (logical == Logical.AND && subject2.isPermittedAll(permissions)) {
                    isAllow = true;
                }
                if (logical == Logical.OR && subject2.isPermittedAll(permissions)) {
                    for (boolean isPermitted : subject2.isPermitted(permissions)) {
                        if (!isPermitted) continue;
                        isAllow = true;
                        break;
                    }
                }
            }
        }
        if (isAllow && clazz.isAnnotationPresent(RequiresAuthentication.class)) {
            subject = SecurityUtils.getSubject();
            isAllow = subject.isAuthenticated();
        }
        if (isAllow && clazz.isAnnotationPresent(RequiresGuest.class)) {
            subject = SecurityUtils.getSubject();
            boolean bl = isAllow = subject.getPrincipals() == null;
        }
        if (isAllow && clazz.isAnnotationPresent(RequiresUser.class)) {
            subject = SecurityUtils.getSubject();
            isAllow = subject.getPrincipals() != null && !subject.getPrincipals().isEmpty();
        }
        return isAllow;
    }
}

