/*
 * Decompiled with CFR 0.152.
 */
package ru.xpoft.vaadin;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.SystemMessagesProvider;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinServlet;
import com.vaadin.server.VaadinServletService;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;
import ru.xpoft.vaadin.SpringApplicationContext;
import ru.xpoft.vaadin.SpringUIProvider;
import ru.xpoft.vaadin.SpringVaadinSystemMessagesProvider;

public class SpringVaadinServlet
extends VaadinServlet {
    private static Logger logger = LoggerFactory.getLogger(SpringVaadinServlet.class);
    private static final String SYSTEM_MESSAGES_BEAN_NAME_PARAMETER = "systemMessagesBeanName";
    private static final String CONTEXT_CONFIG_LOCATION_PARAMETER = "contextConfigLocation";
    private transient ApplicationContext applicationContext;
    private String systemMessagesBeanName = "";

    public void init(ServletConfig config) throws ServletException {
        this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)config.getServletContext());
        if (config.getInitParameter(CONTEXT_CONFIG_LOCATION_PARAMETER) != null) {
            XmlWebApplicationContext context = new XmlWebApplicationContext();
            context.setParent(this.applicationContext);
            context.setConfigLocation(config.getInitParameter(CONTEXT_CONFIG_LOCATION_PARAMETER));
            context.setServletConfig(config);
            context.setServletContext(config.getServletContext());
            context.refresh();
            this.applicationContext = context;
        }
        if (config.getInitParameter(SYSTEM_MESSAGES_BEAN_NAME_PARAMETER) != null) {
            this.systemMessagesBeanName = config.getInitParameter(SYSTEM_MESSAGES_BEAN_NAME_PARAMETER);
            logger.debug("found SYSTEM_MESSAGES_BEAN_NAME_PARAMETER: {}", (Object)this.systemMessagesBeanName);
        }
        if (SpringApplicationContext.getApplicationContext() == null) {
            SpringApplicationContext.setApplicationContext(this.applicationContext);
        }
        super.init(config);
    }

    protected void initializePlugin(VaadinServletService service) {
        String uiProviderProperty;
        if (this.systemMessagesBeanName != null && this.systemMessagesBeanName != "") {
            SpringVaadinSystemMessagesProvider messagesProvider = new SpringVaadinSystemMessagesProvider(this.applicationContext, this.systemMessagesBeanName);
            logger.debug("set SpringVaadinSystemMessagesProvider");
            service.setSystemMessagesProvider((SystemMessagesProvider)messagesProvider);
        }
        if ((uiProviderProperty = service.getDeploymentConfiguration().getApplicationOrSystemProperty("UIProvider", null)) == null) {
            service.addSessionInitListener(new SessionInitListener(){

                public void sessionInit(SessionInitEvent event) throws ServiceException {
                    event.getSession().addUIProvider((UIProvider)new SpringUIProvider());
                }
            });
        }
    }

    protected VaadinServletService createServletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        VaadinServletService service = super.createServletService(deploymentConfiguration);
        this.initializePlugin(service);
        return service;
    }
}

