/*
 * Decompiled with CFR 0.152.
 */
package ru.xpoft.vaadin;

import com.vaadin.server.DeploymentConfiguration;
import com.vaadin.server.ServiceException;
import com.vaadin.server.SessionInitEvent;
import com.vaadin.server.SessionInitListener;
import com.vaadin.server.SystemMessagesProvider;
import com.vaadin.server.UIProvider;
import com.vaadin.server.VaadinPortlet;
import com.vaadin.server.VaadinPortletService;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.portlet.context.PortletApplicationContextUtils;
import org.springframework.web.portlet.context.XmlPortletApplicationContext;
import ru.xpoft.vaadin.SpringApplicationContext;
import ru.xpoft.vaadin.SpringUIProvider;
import ru.xpoft.vaadin.SpringVaadinSystemMessagesProvider;

public class SpringVaadinPortlet
extends VaadinPortlet {
    private static Logger logger = LoggerFactory.getLogger(SpringVaadinPortlet.class);
    private static final String SYSTEM_MESSAGES_BEAN_NAME_PARAMETER = "systemMessagesBeanName";
    private static final String CONTEXT_CONFIG_LOCATION_PARAMETER = "contextConfigLocation";
    private transient ApplicationContext applicationContext;
    private String systemMessagesBeanName = "";

    public void init(PortletConfig config) throws PortletException {
        this.applicationContext = PortletApplicationContextUtils.getWebApplicationContext((PortletContext)config.getPortletContext());
        if (config.getInitParameter(CONTEXT_CONFIG_LOCATION_PARAMETER) != null) {
            XmlPortletApplicationContext context = new XmlPortletApplicationContext();
            context.setParent(this.applicationContext);
            context.setConfigLocation(config.getInitParameter(CONTEXT_CONFIG_LOCATION_PARAMETER));
            context.setPortletConfig(config);
            context.setPortletContext(config.getPortletContext());
            context.refresh();
            this.applicationContext = context;
        }
        if (config.getInitParameter(SYSTEM_MESSAGES_BEAN_NAME_PARAMETER) != null) {
            this.systemMessagesBeanName = config.getInitParameter(SYSTEM_MESSAGES_BEAN_NAME_PARAMETER);
            logger.debug("found SYSTEM_MESSAGES_BEAN_NAME_PARAMETER: {}", (Object)this.systemMessagesBeanName);
        }
        if (SpringApplicationContext.getApplicationContext() == null) {
            SpringApplicationContext.setApplicationContext(this.applicationContext);
        }
        super.init(config);
    }

    protected void initializePlugin(VaadinPortletService service) {
        String uiProviderProperty;
        if (this.systemMessagesBeanName != null && this.systemMessagesBeanName != "") {
            SpringVaadinSystemMessagesProvider messagesProvider = new SpringVaadinSystemMessagesProvider(this.applicationContext, this.systemMessagesBeanName);
            logger.debug("set SpringVaadinSystemMessagesProvider");
            service.setSystemMessagesProvider((SystemMessagesProvider)messagesProvider);
        }
        if ((uiProviderProperty = service.getDeploymentConfiguration().getApplicationOrSystemProperty("UIProvider", null)) == null) {
            service.addSessionInitListener(new SessionInitListener(){

                public void sessionInit(SessionInitEvent event) throws ServiceException {
                    event.getSession().addUIProvider((UIProvider)new SpringUIProvider());
                }
            });
        }
    }

    protected VaadinPortletService createPortletService(DeploymentConfiguration deploymentConfiguration) throws ServiceException {
        VaadinPortletService service = super.createPortletService(deploymentConfiguration);
        this.initializePlugin(service);
        return service;
    }
}

