/*
 * Decompiled with CFR 0.152.
 */
package ru.xpoft.vaadin;

import com.vaadin.navigator.NavigationStateManager;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.xpoft.vaadin.SpringApplicationContext;
import ru.xpoft.vaadin.SpringViewProvider;
import ru.xpoft.vaadin.VaadinView;
import ru.xpoft.vaadin.ViewCacheContainer;

public class DiscoveryNavigator
extends Navigator
implements ViewCacheContainer {
    private static Logger logger = LoggerFactory.getLogger(DiscoveryNavigator.class);
    protected static final List<ViewCache> views = Collections.synchronizedList(new ArrayList());
    private final Map<String, View> viewScoped = Collections.synchronizedMap(new HashMap());

    public DiscoveryNavigator(UI ui, ComponentContainer container) {
        super(ui, container);
        this.initViews();
    }

    public DiscoveryNavigator(UI ui, SingleComponentContainer container) {
        super(ui, container);
        this.initViews();
    }

    public DiscoveryNavigator(UI ui, ViewDisplay display) {
        super(ui, display);
        this.initViews();
    }

    public DiscoveryNavigator(UI ui, NavigationStateManager stateManager, ViewDisplay display) {
        super(ui, stateManager, display);
        this.initViews();
    }

    protected void initViews() {
        if (views.isEmpty()) {
            logger.debug("discovery views from spring context");
            long start = Calendar.getInstance().getTimeInMillis();
            String[] beansName = SpringApplicationContext.getApplicationContext().getBeanDefinitionNames();
            if (SpringApplicationContext.getApplicationContext().getParent() != null) {
                String[] parentBeansName = SpringApplicationContext.getApplicationContext().getParent().getBeanDefinitionNames();
                String[] newBeansName = new String[beansName.length + parentBeansName.length];
                System.arraycopy(beansName, 0, newBeansName, 0, beansName.length);
                System.arraycopy(parentBeansName, 0, newBeansName, beansName.length, parentBeansName.length);
                beansName = newBeansName;
            }
            for (String beanName : beansName) {
                Class beanClass = SpringApplicationContext.getApplicationContext().getType(beanName);
                if (beanClass == null || !beanClass.isAnnotationPresent(VaadinView.class) || !View.class.isAssignableFrom(beanClass)) continue;
                VaadinView vaadinView = beanClass.getAnnotation(VaadinView.class);
                String viewName = vaadinView.value();
                boolean viewCached = vaadinView.cached();
                ViewCache viewCache = new ViewCache(viewName, beanName, beanClass, viewCached);
                views.add(viewCache);
                logger.debug("view name: \"{}\", class: {}, viewCached: {}", new Object[]{viewName, beanClass, viewCached});
            }
            long end = Calendar.getInstance().getTimeInMillis();
            logger.debug("time: {}ms", (Object)(end - start));
        } else {
            logger.debug("discovery views from cache");
        }
        this.addCachedBeans();
    }

    public void addBeanView(String viewName, Class<? extends View> viewClass) {
        this.addBeanView(viewName, viewClass, false);
    }

    public void addBeanView(String viewName, Class<? extends View> viewClass, boolean cached) {
        if (viewName == null || viewClass == null) {
            throw new IllegalArgumentException("view and viewClass must be non-null");
        }
        String[] beanNames = SpringApplicationContext.getApplicationContext().getBeanNamesForType(viewClass);
        if (beanNames.length != 1) {
            throw new IllegalArgumentException("cant't resolve bean name for class :" + viewClass.getName());
        }
        this.removeView(viewName);
        this.addBeanView(viewName, beanNames[0], viewClass, cached);
    }

    protected void addCachedBeans() {
        for (ViewCache view : views) {
            this.addBeanView(view.name, view.beanName, view.clazz, view.cached);
        }
    }

    protected void addBeanView(String viewName, String beanName, Class<? extends View> viewClass, boolean cached) {
        this.addProvider((ViewProvider)new SpringViewProvider(viewName, beanName, viewClass, cached, this));
    }

    public void navigateTo(String navigationState) {
        if (navigationState == null) {
            navigationState = "";
        }
        if (navigationState.startsWith("!")) {
            super.navigateTo(navigationState.substring(1));
        } else {
            super.navigateTo(navigationState);
        }
    }

    @Override
    public View getView(String name, String beanName, boolean cached) {
        if (cached) {
            if (this.viewScoped.containsKey(name)) {
                return this.viewScoped.get(name);
            }
            View view = (View)SpringApplicationContext.getApplicationContext().getBean(beanName);
            this.viewScoped.put(name, view);
            return view;
        }
        return (View)SpringApplicationContext.getApplicationContext().getBean(beanName);
    }

    protected class ViewCache
    implements Serializable {
        private final String name;
        private final String beanName;
        private final Class<? extends View> clazz;
        private final boolean cached;

        ViewCache(String name, String beanName, Class<? extends View> clazz, boolean cached) {
            this.name = name;
            this.beanName = beanName;
            this.clazz = clazz;
            this.cached = cached;
        }

        public String getName() {
            return this.name;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Class<? extends View> getClazz() {
            return this.clazz;
        }

        public boolean isCached() {
            return this.cached;
        }
    }
}

