/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.gestures;

import android.os.Handler;
import android.os.Message;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.TiledImageViewApi;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.dev.DevTools;
import cz.mzk.tiledimageview.gestures.GestureHandler;

public class DoubletapZoomHandler
extends Handler {
    public static final long ANIM_LENGTH_MS = 300L;
    public static final double MIN_ANIMATION_SCALE_FACTOR = 1.0;
    public static final double MAX_ANIMATION_SCALE_FACTOR = 3.0;
    public static final int ANIM_STEPS = 10;
    public static final long ANIM_STEP_MS = 30L;
    private static final Logger LOGGER = new Logger(DoubletapZoomHandler.class);
    private static final double SCALE_DIFF = 2.0;
    private static final double SCALE_STEP = 0.2;
    private final TiledImageViewApi mImageViewApi;
    private final DevTools mDevTools;
    private final GestureHandler mAbstractGestureHandler;
    private State mState = State.IDLE;
    private Thread mWorkerThread;
    private int mCorrectWorkerId = 0;
    private PointD mInitialFocusInImageCoords;
    private PointD mCurrentFocusInCanvas;
    private VectorD mAccumulatedShift = VectorD.ZERO_VECTOR;
    private VectorD mActiveShift = VectorD.ZERO_VECTOR;
    private double mAccumulatedScaleFactor = 1.0;
    private double mActiveScaleFactor = 1.0;

    public DoubletapZoomHandler(TiledImageViewApi imageViewApi, DevTools devTools) {
        this.mImageViewApi = imageViewApi;
        this.mAbstractGestureHandler = new GestureHandler(imageViewApi, devTools);
        this.mDevTools = devTools;
    }

    public void startZooming(PointD doubleTapCenterInCanvasCoords) {
        this.mState = State.ZOOMING;
        LOGGER.i(this.mState.name());
        this.mCurrentFocusInCanvas = doubleTapCenterInCanvasCoords;
        this.mInitialFocusInImageCoords = Utils.toImageCoords(this.mCurrentFocusInCanvas, this.mImageViewApi.getTotalScaleFactor(), this.mImageViewApi.getTotalShift());
        this.mWorkerThread = new Thread(new AnimationRunnable(this, this.mCorrectWorkerId));
        this.mWorkerThread.start();
        this.devUpdateZoomCenters();
    }

    private void devUpdateZoomCenters() {
        if (this.mDevTools != null) {
            this.mDevTools.setDoubletapZoomCenters(this.mCurrentFocusInCanvas, this.mInitialFocusInImageCoords);
        }
    }

    public void handleMessage(Message msg) {
        switch (this.mState) {
            case ZOOMING: {
                int workerId = msg.arg1;
                if (workerId == this.mCorrectWorkerId) {
                    int i = msg.arg2;
                    if (i <= 10) {
                        double ratio = 1.0 + (double)i * 0.2;
                        boolean maxZoomLevelReached = this.zoomIn(ratio);
                        if (!maxZoomLevelReached) break;
                        this.stopAnimation();
                        break;
                    }
                    LOGGER.v(String.format("ui thead: message from thread %d: %d - ignoring (last step reached)", workerId, i));
                    this.stopAnimation();
                    break;
                }
                LOGGER.v(String.format("ui thead: message from thread %d: %d - ignoring (old thread)", workerId, msg.arg2));
                break;
            }
            case IDLE: {
                LOGGER.v(String.format("ui thead: message from thread %d: %d - ignoring (mState IDLE)", msg.arg1, msg.arg2));
            }
        }
    }

    private boolean zoomIn(double currentScaleFactor) {
        boolean maxScaleFactorReached;
        LOGGER.d("scale factor: " + currentScaleFactor);
        this.mActiveScaleFactor = 1.0;
        double maxTotalScaleFactor = this.mImageViewApi.getMaxScaleFactor();
        double totalScaleFactorWithoutActive = this.mImageViewApi.getTotalScaleFactor();
        double maxActiveScaleFactor = maxTotalScaleFactor / totalScaleFactorWithoutActive;
        boolean bl = maxScaleFactorReached = currentScaleFactor >= maxActiveScaleFactor;
        if (maxScaleFactorReached) {
            LOGGER.d("max scale reached");
            this.mActiveScaleFactor = maxActiveScaleFactor;
        } else {
            this.mActiveScaleFactor = currentScaleFactor;
        }
        if (this.mActiveScaleFactor > 1.0) {
            LOGGER.d("zooming in");
        } else {
            LOGGER.d("zooming out");
        }
        this.mActiveShift = VectorD.ZERO_VECTOR;
        PointD initialFocusToBeShiftedInCanvasCoords = Utils.toCanvasCoords(this.mInitialFocusInImageCoords, this.mImageViewApi.getTotalScaleFactor(), this.mImageViewApi.getTotalShift());
        VectorD newShift = this.mCurrentFocusInCanvas.minus(initialFocusToBeShiftedInCanvasCoords);
        this.mActiveShift = this.mAbstractGestureHandler.limitNewShift(newShift);
        this.mImageViewApi.invalidate();
        return maxScaleFactorReached;
    }

    public State getState() {
        return this.mState;
    }

    public double getCurrentScaleFactor() {
        return this.mAccumulatedScaleFactor * this.mActiveScaleFactor;
    }

    public VectorD getCurrentZoomShift() {
        return VectorD.sum(this.mAccumulatedShift, this.mActiveShift);
    }

    public void reset() {
        LOGGER.d("resetting");
        if (this.mState != State.IDLE) {
            LOGGER.w("animation still running");
            this.stopAnimation();
        }
        this.mAccumulatedShift = VectorD.ZERO_VECTOR;
        this.mAccumulatedScaleFactor = 1.0;
    }

    public void stopAnimation() {
        LOGGER.d("stopping animation");
        if (this.mState == State.IDLE) {
            LOGGER.w("already stopped");
        } else {
            if (this.mWorkerThread != null && this.mWorkerThread.isAlive()) {
                this.mWorkerThread.interrupt();
            }
            this.mWorkerThread = null;
            ++this.mCorrectWorkerId;
            LOGGER.v("correct worker id: " + this.mCorrectWorkerId);
            this.mAccumulatedScaleFactor *= this.mActiveScaleFactor;
            this.mActiveScaleFactor = 1.0;
            this.mAccumulatedShift = VectorD.sum(this.mAccumulatedShift, this.mActiveShift);
            this.mActiveShift = VectorD.ZERO_VECTOR;
            this.mState = State.ZOOMING;
            LOGGER.i(this.mState.name());
        }
    }

    private class AnimationRunnable
    implements Runnable {
        private final Handler handler;
        private final int workerId;

        public AnimationRunnable(Handler handler, int workerId) {
            this.handler = handler;
            this.workerId = workerId;
        }

        @Override
        public void run() {
            int i = 0;
            while (true) {
                Message msg = Message.obtain();
                msg.arg1 = this.workerId;
                msg.arg2 = i++;
                this.handler.sendMessage(msg);
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    public static enum State {
        IDLE,
        ZOOMING;

    }
}

