/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.zoomify;

import cz.mzk.tiledimageview.images.exceptions.InvalidDataException;
import cz.mzk.tiledimageview.images.exceptions.OtherIOException;
import cz.mzk.tiledimageview.images.metadata.ImageMetadataParser;
import cz.mzk.tiledimageview.images.zoomify.ZoomifyImageMetadata;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ZoomifyMetadataParser
implements ImageMetadataParser {
    @Override
    public ZoomifyImageMetadata parse(String imagePropertiesXml, String imagePropertiesUrl) throws InvalidDataException, OtherIOException {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(false);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput((Reader)new StringReader(imagePropertiesXml));
            boolean elementImagePropertiesStarted = false;
            boolean elementImagePropertiesEnded = false;
            int width = -1;
            int height = -1;
            int numtiles = -1;
            int numimages = -1;
            double version = 0.0;
            int tileSize = -1;
            int eventType = xpp.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    if (!xpp.getName().equals("IMAGE_PROPERTIES")) {
                        throw new InvalidDataException(imagePropertiesUrl, "Unexpected element " + xpp.getName());
                    }
                    elementImagePropertiesStarted = true;
                    width = this.getAttributeIntegerValue(xpp, "WIDTH", imagePropertiesUrl);
                    height = this.getAttributeIntegerValue(xpp, "HEIGHT", imagePropertiesUrl);
                    numtiles = this.getAttributeIntegerValue(xpp, "NUMTILES", imagePropertiesUrl);
                    numimages = this.getAttributeIntegerValue(xpp, "NUMIMAGES", imagePropertiesUrl);
                    tileSize = this.getAttributeIntegerValue(xpp, "TILESIZE", imagePropertiesUrl);
                    version = this.getAttributeDoubleValue(xpp, "VERSION", imagePropertiesUrl);
                } else if (eventType == 3) {
                    if (!xpp.getName().equals("IMAGE_PROPERTIES")) {
                        throw new InvalidDataException(imagePropertiesUrl, "Unexpected element " + xpp.getName());
                    }
                    elementImagePropertiesEnded = true;
                }
                eventType = xpp.next();
            }
            if (!elementImagePropertiesStarted) {
                throw new InvalidDataException(imagePropertiesUrl, "Element IMAGE_PROPERTIES not found");
            }
            if (!elementImagePropertiesEnded) {
                throw new InvalidDataException(imagePropertiesUrl, "Element IMAGE_PROPERTIES not closed");
            }
            if (version != 1.8) {
                throw new InvalidDataException(imagePropertiesUrl, "Unsupported tiles version: " + version);
            }
            if (numimages != 1) {
                throw new InvalidDataException(imagePropertiesUrl, "Unsupported number of images: " + numimages);
            }
            return new ZoomifyImageMetadata(width, height, numtiles, tileSize);
        }
        catch (XmlPullParserException e1) {
            throw new InvalidDataException(imagePropertiesUrl, e1.getMessage());
        }
        catch (IOException e) {
            throw new OtherIOException(e.getMessage(), imagePropertiesUrl);
        }
    }

    private Double getAttributeDoubleValue(XmlPullParser xpp, String attrName, String imagePropertiesUrl) throws InvalidDataException {
        String attrValue = this.getAttributeStringValue(xpp, attrName, imagePropertiesUrl);
        try {
            return Double.valueOf(attrValue);
        }
        catch (NumberFormatException e) {
            throw new InvalidDataException(imagePropertiesUrl, "invalid content of attribute " + attrName + ": '" + attrValue + "'");
        }
    }

    private int getAttributeIntegerValue(XmlPullParser xpp, String attrName, String imagePropertiesUrl) throws InvalidDataException {
        String attrValue = this.getAttributeStringValue(xpp, attrName, imagePropertiesUrl);
        try {
            return Integer.valueOf(attrValue);
        }
        catch (NumberFormatException e) {
            throw new InvalidDataException(imagePropertiesUrl, "invalid content of attribute " + attrName + ": '" + attrValue + "'");
        }
    }

    private String getAttributeStringValue(XmlPullParser xpp, String attrName, String imagePropertiesUrl) throws InvalidDataException {
        String attrValue = xpp.getAttributeValue(null, attrName);
        if (attrValue == null) {
            throw new InvalidDataException(imagePropertiesUrl, "missing attribute " + attrName);
        }
        if (attrValue.isEmpty()) {
            throw new InvalidDataException(imagePropertiesUrl, "empty attribute " + attrName);
        }
        return attrValue;
    }
}

