/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.tasks;

import android.graphics.Bitmap;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.TiledImageView;
import cz.mzk.tiledimageview.images.Downloader;
import cz.mzk.tiledimageview.images.cache.CacheManager;
import cz.mzk.tiledimageview.images.cache.TileCache;
import cz.mzk.tiledimageview.images.exceptions.ImageServerResponseException;
import cz.mzk.tiledimageview.images.exceptions.OtherIOException;
import cz.mzk.tiledimageview.images.exceptions.TooManyRedirectionsException;
import cz.mzk.tiledimageview.images.tasks.ConcurrentAsyncTask;
import cz.mzk.tiledimageview.images.tasks.TaskManager;

public class DeliverTileIntoMemoryCacheTask
extends ConcurrentAsyncTask<Void, Void, Boolean> {
    private static final Logger LOGGER = new Logger(DeliverTileIntoMemoryCacheTask.class);
    private final String mTileImageUrl;
    private final String mCacheKey;
    private final TiledImageView.TileDownloadErrorListener mErrorListener;
    private final TiledImageView.TileDownloadSuccessListener mSuccessListener;
    private final TaskManager.TaskListener mTaskManagerListener;
    private OtherIOException otherIoException;
    private TooManyRedirectionsException tooManyRedirectionsException;
    private ImageServerResponseException imageServerResponseException;

    public DeliverTileIntoMemoryCacheTask(String tileImageUrl, String cacheKey, TiledImageView.TileDownloadSuccessListener successListener, TiledImageView.TileDownloadErrorListener errorListener, TaskManager.TaskListener taskManagerListener) {
        this.mTileImageUrl = tileImageUrl;
        this.mCacheKey = cacheKey;
        this.mSuccessListener = successListener;
        this.mErrorListener = errorListener;
        this.mTaskManagerListener = taskManagerListener;
    }

    protected Boolean doInBackground(Void ... params) {
        if (!this.isCancelled()) {
            TileCache tileCache = CacheManager.getTileCache();
            boolean diskCacheEnabled = tileCache.isDiskCacheEnabled();
            if (diskCacheEnabled) {
                boolean inDiskCache = tileCache.isItemInDiskCache(this.mCacheKey);
                LOGGER.d("is in disk cache: " + inDiskCache);
                if (!this.isCancelled()) {
                    if (inDiskCache) {
                        Bitmap fromDiskCache = (Bitmap)tileCache.getItemFromDiskCache(this.mCacheKey);
                        if (!this.isCancelled()) {
                            if (fromDiskCache != null) {
                                LOGGER.d("disk cache returned bitmap");
                                tileCache.storeItemToMemoryCache(this.mCacheKey, fromDiskCache);
                                LOGGER.d("bitmap stored into memory cache");
                                return true;
                            }
                            LOGGER.w("disk cache returned null");
                            return false;
                        }
                    } else {
                        this.fetchFromNetAndSave(tileCache, diskCacheEnabled);
                    }
                }
            } else {
                this.fetchFromNetAndSave(tileCache, false);
            }
        }
        return false;
    }

    private boolean fetchFromNetAndSave(TileCache tileCache, boolean diskCacheEnabled) {
        Bitmap fromNet = this.downloadTile(this.mTileImageUrl);
        if (fromNet != null) {
            LOGGER.d("fetched from net");
            if (!this.isCancelled()) {
                tileCache.storeItemToMemoryCache(this.mCacheKey, fromNet);
                LOGGER.d("bitmap stored into memory cache");
            }
            if (!this.isCancelled()) {
                if (diskCacheEnabled) {
                    tileCache.storeItemToDiskCache(this.mCacheKey, fromNet);
                    LOGGER.d("bitmap stored into disk cache");
                }
                return true;
            }
        } else {
            LOGGER.d("fetched from net but null");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap downloadTile(String mTileImageUrl) {
        try {
            Bitmap tile;
            Bitmap bitmap = tile = Downloader.downloadTile(mTileImageUrl);
            return bitmap;
        }
        catch (TooManyRedirectionsException e) {
            this.tooManyRedirectionsException = e;
        }
        catch (ImageServerResponseException e) {
            this.imageServerResponseException = e;
        }
        catch (OtherIOException e) {
            this.otherIoException = e;
        }
        finally {
            LOGGER.v("tile processing task finished");
        }
        return null;
    }

    protected void onPostExecute(Boolean success) {
        if (this.mTaskManagerListener != null) {
            this.mTaskManagerListener.onFinished(new Object[0]);
        }
        if (success.booleanValue()) {
            if (this.mSuccessListener != null) {
                this.mSuccessListener.onTileDelivered();
            }
        } else if (this.mErrorListener != null) {
            if (this.tooManyRedirectionsException != null) {
                this.mErrorListener.onTileRedirectionLoop(this.tooManyRedirectionsException.getUrl(), this.tooManyRedirectionsException.getRedirections());
            } else if (this.imageServerResponseException != null) {
                this.mErrorListener.onTileUnhandableResponse(this.imageServerResponseException.getUrl(), this.imageServerResponseException.getErrorCode());
            } else if (this.otherIoException != null) {
                this.mErrorListener.onTileDataTransferError(this.otherIoException.getUrl(), this.otherIoException.getMessage());
            }
        }
    }

    protected void onCancelled(Boolean succes) {
        if (this.mTaskManagerListener != null) {
            this.mTaskManagerListener.onCanceled();
        }
    }
}

