/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.images.exceptions.ImageServerResponseException;
import cz.mzk.tiledimageview.images.exceptions.OtherIOException;
import cz.mzk.tiledimageview.images.exceptions.TooManyRedirectionsException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class Downloader {
    public static final int MAX_REDIRECTIONS = 5;
    public static final int METADATA_CONNECTION_TIMEOUT = 1000;
    public static final int METADATA_READ_TIMEOUT = 3000;
    public static final int TILES_CONNECTION_TIMEOUT = 2000;
    public static final int TILES_READ_TIMEOUT = 10000;
    private static final Logger LOGGER = new Logger(Downloader.class);

    public static Bitmap downloadTile(String tileUrl) throws TooManyRedirectionsException, ImageServerResponseException, OtherIOException {
        return Downloader.downloadTile(tileUrl, 5);
    }

    private static Bitmap downloadTile(String tileUrl, int remainingRedirections) throws TooManyRedirectionsException, ImageServerResponseException, OtherIOException {
        LOGGER.d("downloading tile from " + tileUrl);
        if (remainingRedirections == 0) {
            throw new TooManyRedirectionsException(tileUrl, 5);
        }
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(tileUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(2000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setInstanceFollowRedirects(false);
            int responseCode = urlConnection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    Bitmap bitmap = Downloader.bitmapFromUrlConnection(urlConnection);
                    return bitmap;
                }
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 305: 
                case 307: {
                    String location = urlConnection.getHeaderField("Location");
                    if (location == null || location.isEmpty()) {
                        throw new ImageServerResponseException(tileUrl, responseCode);
                    }
                    urlConnection.disconnect();
                    Bitmap bitmap = Downloader.downloadTile(location, remainingRedirections - 1);
                    return bitmap;
                }
            }
            try {
                throw new ImageServerResponseException(tileUrl, responseCode);
            }
            catch (IOException e) {
                throw new OtherIOException(e.getMessage(), tileUrl);
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    private static Bitmap bitmapFromUrlConnection(HttpURLConnection urlConnection) throws IOException {
        try (BufferedInputStream in = null;){
            in = new BufferedInputStream(urlConnection.getInputStream());
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in);
            return bitmap;
        }
    }

    public static String downloadMetadata(String metadataUrl) throws TooManyRedirectionsException, ImageServerResponseException, OtherIOException {
        return Downloader.downloadMetadata(metadataUrl, 5);
    }

    private static String downloadMetadata(String metadataUrl, int remainingRedirections) throws TooManyRedirectionsException, ImageServerResponseException, OtherIOException {
        LOGGER.d("downloading metadata from " + metadataUrl);
        if (remainingRedirections == 0) {
            throw new TooManyRedirectionsException(metadataUrl, 5);
        }
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(metadataUrl);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setConnectTimeout(1000);
            urlConnection.setReadTimeout(3000);
            urlConnection.setInstanceFollowRedirects(false);
            int responseCode = urlConnection.getResponseCode();
            String location = urlConnection.getHeaderField("Location");
            switch (responseCode) {
                case 200: {
                    String string2 = Downloader.stringFromUrlConnection(urlConnection);
                    return string2;
                }
                case 300: {
                    if (location == null || location.isEmpty()) {
                        throw new ImageServerResponseException(metadataUrl, responseCode);
                    }
                    urlConnection.disconnect();
                    String string3 = Downloader.downloadMetadata(location, remainingRedirections - 1);
                    return string3;
                }
                case 301: {
                    if (location == null || location.isEmpty()) {
                        throw new ImageServerResponseException(metadataUrl, responseCode);
                    }
                    urlConnection.disconnect();
                    String string4 = Downloader.downloadMetadata(location, remainingRedirections - 1);
                    return string4;
                }
                case 302: 
                case 303: 
                case 305: 
                case 307: {
                    if (location == null || location.isEmpty()) {
                        throw new ImageServerResponseException(metadataUrl, responseCode);
                    }
                    urlConnection.disconnect();
                    String string5 = Downloader.downloadMetadata(location, remainingRedirections - 1);
                    return string5;
                }
            }
            try {
                throw new ImageServerResponseException(metadataUrl, responseCode);
            }
            catch (IOException e) {
                throw new OtherIOException(e.getMessage(), metadataUrl);
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stringFromUrlConnection(HttpURLConnection urlConnection) throws IOException {
        BufferedInputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = new BufferedInputStream(urlConnection.getInputStream());
            byte[] buffer = new byte[8192];
            out = new ByteArrayOutputStream();
            int readBytes = 0;
            while ((readBytes = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, readBytes);
            }
            String string2 = out.toString();
            return string2;
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

