/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.gestures;

import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.TiledImageViewApi;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.dev.DevTools;
import cz.mzk.tiledimageview.gestures.GestureHandler;

public class PinchZoomHandler
extends GestureHandler {
    private static final Logger LOGGER = new Logger(PinchZoomHandler.class);
    private State mState = State.IDLE;
    private double mInitialSpan;
    private PointD mInitialFocusInImageCoords;
    private VectorD mAccumalatedShift = VectorD.ZERO_VECTOR;
    private VectorD mActiveShift = VectorD.ZERO_VECTOR;
    private double mAccumulatedScaleFactor = 1.0;
    private double mActiveScaleFactor = 1.0;

    public PinchZoomHandler(TiledImageViewApi imageView, DevTools devTools) {
        super(imageView, devTools);
    }

    public State getmState() {
        return this.mState;
    }

    public double getCurrentScaleFactor() {
        return this.mAccumulatedScaleFactor * this.mActiveScaleFactor;
    }

    public VectorD getCurrentShift() {
        return VectorD.sum(this.mAccumalatedShift, this.mActiveShift);
    }

    public void startZooming(double span, PointD focus) {
        this.mInitialSpan = span;
        this.mInitialFocusInImageCoords = Utils.toImageCoords(focus, this.mImageViewApi.getTotalScaleFactor(), this.mImageViewApi.getTotalShift());
        this.devUpdateZoomCenters(focus);
        this.mState = State.READY_TO_PINCH;
        LOGGER.i(this.mState.name());
    }

    public void zoom(PointD currentFocusInCanvas, double currentSpan) {
        this.mState = State.PINCHING;
        LOGGER.i(this.mState.name());
        this.mActiveScaleFactor = 1.0;
        double currentScaleFactor = currentSpan / this.mInitialSpan;
        LOGGER.d("scale factor: " + currentScaleFactor);
        double totalScaleFactorWithoutActive = this.mImageViewApi.getTotalScaleFactor();
        double maxTotalScaleFactor = this.mImageViewApi.getMaxScaleFactor();
        double maxActiveScaleFactor = maxTotalScaleFactor / totalScaleFactorWithoutActive;
        double minTotalScaleFactor = this.mImageViewApi.getMinScaleFactor();
        double minActiveScaleFactor = minTotalScaleFactor / totalScaleFactorWithoutActive;
        if (currentScaleFactor >= maxActiveScaleFactor) {
            LOGGER.d("max scale reached");
            this.mActiveScaleFactor = maxActiveScaleFactor;
        } else {
            this.mActiveScaleFactor = currentScaleFactor <= minActiveScaleFactor ? minActiveScaleFactor : currentScaleFactor;
        }
        if (this.mActiveScaleFactor > 1.0) {
            LOGGER.d("zooming in");
        } else {
            LOGGER.d("zooming out");
        }
        this.mActiveShift = VectorD.ZERO_VECTOR;
        PointD initialFocusToBeShiftedInCanvasCoords = Utils.toCanvasCoords(this.mInitialFocusInImageCoords, this.mImageViewApi.getTotalScaleFactor(), this.mImageViewApi.getTotalShift());
        VectorD newShift = currentFocusInCanvas.minus(initialFocusToBeShiftedInCanvasCoords);
        this.mActiveShift = this.limitNewShift(newShift);
        this.devUpdateZoomCenters(currentFocusInCanvas);
        this.mImageViewApi.invalidate();
    }

    private void devUpdateZoomCenters(PointD currentFocusInCanvas) {
        if (this.mDevTools != null) {
            this.mDevTools.setPinchZoomCenters(currentFocusInCanvas, this.mInitialFocusInImageCoords);
        }
    }

    public void finishZooming() {
        this.mAccumulatedScaleFactor *= this.mActiveScaleFactor;
        this.mActiveScaleFactor = 1.0;
        this.mAccumalatedShift = VectorD.sum(this.mAccumalatedShift, this.mActiveShift);
        this.mActiveShift = VectorD.ZERO_VECTOR;
        this.mInitialSpan = 0.0;
        this.mInitialFocusInImageCoords = null;
        this.mState = State.IDLE;
        LOGGER.i(this.mState.name());
    }

    public void reset() {
        this.mAccumalatedShift = VectorD.ZERO_VECTOR;
        this.mActiveShift = VectorD.ZERO_VECTOR;
        this.mAccumulatedScaleFactor = 1.0;
        this.mActiveScaleFactor = 1.0;
    }

    public static enum State {
        IDLE,
        READY_TO_PINCH,
        PINCHING;

    }
}

