/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.images.tasks;

import cz.mzk.tiledimageview.ConcurrentAsyncTask;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.TiledImageView;
import cz.mzk.tiledimageview.cache.CacheManager;
import cz.mzk.tiledimageview.cache.MetadataCache;
import cz.mzk.tiledimageview.images.Downloader;
import cz.mzk.tiledimageview.images.ImageManager;
import cz.mzk.tiledimageview.images.exceptions.ImageServerResponseException;
import cz.mzk.tiledimageview.images.exceptions.InvalidDataException;
import cz.mzk.tiledimageview.images.exceptions.OtherIOException;
import cz.mzk.tiledimageview.images.exceptions.TooManyRedirectionsException;
import cz.mzk.tiledimageview.images.metadata.ImageMetadata;
import cz.mzk.tiledimageview.images.tasks.ImageManagerTaskRegistry;
import cz.mzk.tiledimageview.images.zoomify.ZoomifyMetadataParser;

public class InitImageManagerTask
extends ConcurrentAsyncTask<Void, Void, ImageMetadata> {
    private static final Logger LOGGER = new Logger(InitImageManagerTask.class);
    private final TiledImageView.MetadataInitializationHandler mHandler;
    private final TiledImageView.MetadataInitializationSuccessListener mSuccessListener;
    private final ImageManagerTaskRegistry.TaskFinishedListener mRegistryListener;
    private final ImageManager mImgManager;
    private final String mMetadataUrl;
    private OtherIOException mOtherIoException;
    private TooManyRedirectionsException mTooManyRedirectionsException;
    private ImageServerResponseException mImageServerResponseException;
    private InvalidDataException mInvalidXmlException;

    public InitImageManagerTask(ImageManager imgManager, String metadataUrl, TiledImageView.MetadataInitializationHandler handler, TiledImageView.MetadataInitializationSuccessListener successListener, ImageManagerTaskRegistry.TaskFinishedListener registryListener) {
        this.mImgManager = imgManager;
        this.mMetadataUrl = metadataUrl;
        this.mHandler = handler;
        this.mSuccessListener = successListener;
        this.mRegistryListener = registryListener;
    }

    protected ImageMetadata doInBackground(Void ... params) {
        try {
            if (this.isCancelled()) {
                LOGGER.d("Task canceled before fetching metadata: " + this.mMetadataUrl);
            } else {
                String metadataStr = this.fetchMetadata();
                if (this.isCancelled()) {
                    LOGGER.d("Task canceled before parsing metadata: " + this.mMetadataUrl);
                } else if (metadataStr != null) {
                    switch (this.mImgManager.getTiledImageProtocol()) {
                        case ZOOMIFY: {
                            return new ZoomifyMetadataParser().parse(metadataStr, this.mMetadataUrl);
                        }
                    }
                    return null;
                }
            }
        }
        catch (TooManyRedirectionsException e) {
            this.mTooManyRedirectionsException = e;
        }
        catch (ImageServerResponseException e) {
            this.mImageServerResponseException = e;
        }
        catch (InvalidDataException e) {
            this.mInvalidXmlException = e;
        }
        catch (OtherIOException e) {
            this.mOtherIoException = e;
        }
        return null;
    }

    private String fetchMetadata() throws OtherIOException, TooManyRedirectionsException, ImageServerResponseException {
        MetadataCache cache = CacheManager.getMetadataCache();
        String fromCache = cache.getMetadata(this.mMetadataUrl);
        if (fromCache != null) {
            LOGGER.d("Metadata found in cache: " + this.mMetadataUrl);
            return fromCache;
        }
        LOGGER.d("Metadata not in cache: " + this.mMetadataUrl);
        if (this.isCancelled()) {
            LOGGER.d("Task canceled before downloading metadata: " + this.mMetadataUrl);
            return null;
        }
        LOGGER.d("Downloading metadata: " + this.mMetadataUrl);
        String downloaded = Downloader.downloadMetadata(this.mMetadataUrl);
        cache.storeMetadata(downloaded, this.mMetadataUrl);
        return downloaded;
    }

    protected void onPostExecute(ImageMetadata result) {
        if (this.mRegistryListener != null) {
            this.mRegistryListener.onTaskFinished();
        }
        if (result != null) {
            if (this.mSuccessListener != null) {
                this.mImgManager.init(result);
                this.mSuccessListener.onMetadataDownloaded(this.mImgManager);
            }
            if (this.mHandler != null) {
                this.mHandler.onMetadataInitialized();
            }
        } else if (this.mTooManyRedirectionsException != null) {
            if (this.mHandler != null) {
                this.mHandler.onMetadataRedirectionLoop(this.mTooManyRedirectionsException.getUrl(), this.mTooManyRedirectionsException.getRedirections());
            }
        } else if (this.mImageServerResponseException != null) {
            if (this.mHandler != null) {
                this.mHandler.onMetadataUnhandableResponseCode(this.mImageServerResponseException.getUrl(), this.mImageServerResponseException.getErrorCode());
            }
        } else if (this.mInvalidXmlException != null) {
            if (this.mHandler != null) {
                this.mHandler.onMetadataInvalidData(this.mInvalidXmlException.getUrl(), this.mInvalidXmlException.getMessage());
            }
        } else if (this.mOtherIoException != null && this.mHandler != null) {
            this.mHandler.onMetadataDataTransferError(this.mOtherIoException.getUrl(), this.mOtherIoException.getMessage());
        }
    }

    protected void onCancelled() {
        super.onCancelled();
        if (this.mRegistryListener != null) {
            this.mRegistryListener.onTaskFinished();
        }
    }
}

