/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.dev;

import cz.mzk.tiledimageview.Point;
import java.util.ArrayList;
import java.util.List;

public class DevPoints {
    private final Point center;
    private final List<Point> corners;
    private final List<Point> clickedPoints;
    private Point initialZoomCenter;

    public DevPoints(int imageWidth, int imageHeight) {
        this.center = new Point(imageWidth / 2, imageHeight / 2);
        this.corners = this.initCorners(imageWidth, imageHeight);
        this.clickedPoints = new ArrayList<Point>();
    }

    private List<Point> initCorners(int imageWidth, int imageHeight) {
        ArrayList<Point> corners = new ArrayList<Point>();
        corners.add(new Point(0, 0));
        corners.add(new Point(imageWidth, 0));
        corners.add(new Point(imageWidth, imageHeight));
        corners.add(new Point(0, imageHeight));
        return corners;
    }

    public Point getCenter() {
        return this.center;
    }

    public List<Point> getCorners() {
        return this.corners;
    }

    public List<Point> getClickedPoints() {
        return this.clickedPoints;
    }

    public void addOtherPoint(Point point) {
        this.clickedPoints.add(point);
    }

    public Point getInitialZoomCenter() {
        return this.initialZoomCenter;
    }

    public void setInitialZoomCenter(Point initialZoomCenter) {
        this.initialZoomCenter = initialZoomCenter;
    }
}

