/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache.tmp;

import android.graphics.Bitmap;
import android.util.LruCache;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.cache.tmp.AbstractTileCache;
import cz.mzk.tiledimageview.cache.tmp.TilesCache;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;

public class MemoryTilesCache
extends AbstractTileCache
implements TilesCache {
    private static final Logger LOGGER = new Logger(MemoryTilesCache.class);
    private final LruCache<String, Bitmap> mMemoryCache;
    private final Object mMemoryCacheLock = new Object();
    private TilesCache.State state = TilesCache.State.INITIALIZING;

    public MemoryTilesCache() {
        this(MemoryTilesCache.getDefaultMemoryCacheSizeKB());
    }

    public MemoryTilesCache(int cacheSizeKB) {
        if (cacheSizeKB == 0) {
            this.state = TilesCache.State.DISABLED;
            this.mMemoryCache = null;
        } else {
            this.mMemoryCache = new LruCache<String, Bitmap>(cacheSizeKB){

                protected int sizeOf(String key, Bitmap bitmap) {
                    return MemoryTilesCache.this.getBitmapSizeInKB(bitmap);
                }
            };
            LOGGER.d("Lru cache allocated with " + cacheSizeKB + " kB");
            this.state = TilesCache.State.READY;
        }
    }

    @Override
    public Bitmap getTile(String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        return (Bitmap)this.mMemoryCache.get((Object)this.buildKey(zoomifyBaseUrl, tilePositionInPyramid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTile(Bitmap bmp, String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        String key = this.buildKey(zoomifyBaseUrl, tilePositionInPyramid);
        Object object = this.mMemoryCacheLock;
        synchronized (object) {
            if (this.mMemoryCache.get((Object)key) == null) {
                LOGGER.d("storing " + key);
                this.mMemoryCache.put((Object)key, (Object)bmp);
                this.logStatistics();
            }
        }
    }

    private void logStatistics() {
        int hitCount = this.mMemoryCache.hitCount();
        int missCount = this.mMemoryCache.missCount();
        float hitRatio = (float)hitCount / (float)(hitCount + missCount) * 100.0f;
        LOGGER.d(String.format("hit ratio: %,.2f %%", Float.valueOf(hitRatio)));
    }

    @Override
    public TilesCache.State getState() {
        return this.state;
    }
}

