/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache.tmp;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.cache.DiskLruCache;
import cz.mzk.tiledimageview.cache.InitDiskCacheTask;
import cz.mzk.tiledimageview.cache.tmp.AbstractTileCache;
import cz.mzk.tiledimageview.cache.tmp.TilesCache;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;
import java.io.File;
import java.io.InputStream;

public class DiskTilesCache
extends AbstractTileCache
implements TilesCache {
    private static final Logger LOGGER = new Logger(DiskTilesCache.class);
    private DiskLruCache mCache = null;
    private TilesCache.State state = TilesCache.State.INITIALIZING;

    public DiskTilesCache(Context context, int diskCacheSize, String diskCacheDir, boolean clearCache) {
        this.initDiskCacheAsync(context, diskCacheSize, diskCacheDir, clearCache);
    }

    private void initDiskCacheAsync(Context context, int diskCacheSize, String diskCacheDir, boolean clearCache) {
        try {
            File cacheDir = DiskTilesCache.getDiskCacheDir(context, diskCacheDir);
            int appVersion = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
            new InitDiskCacheTask(appVersion, diskCacheSize, clearCache, new InitDiskCacheTask.Listener(){

                @Override
                public void onFinished(DiskLruCache cache) {
                    DiskTilesCache.this.mCache = cache;
                    DiskTilesCache.this.state = TilesCache.State.READY;
                }

                @Override
                public void onError() {
                    LOGGER.i("disabling cache");
                    DiskTilesCache.this.state = TilesCache.State.DISABLED;
                }
            }).execute(new File[]{cacheDir});
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Bitmap getTile(String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        String key = this.buildKey(zoomifyBaseUrl, tilePositionInPyramid);
        return this.getTileFromDiskCache(key);
    }

    private Bitmap getTileFromDiskCache(String key) {
        try {
            DiskLruCache.Snapshot snapshot = this.mCache.get(key);
            if (snapshot != null) {
                InputStream in = snapshot.getInputStream(0);
                Bitmap stream = BitmapFactory.decodeStream((InputStream)in);
                return stream;
            }
            return null;
        }
        catch (DiskLruCache.DiskLruCacheException e) {
            LOGGER.i("error loading tile from disk cache: " + key, e);
            return null;
        }
    }

    @Override
    public void storeTile(Bitmap tile, String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        String key = this.buildKey(zoomifyBaseUrl, tilePositionInPyramid);
        this.storeTileToDiskCache(key, tile);
    }

    private void storeTileToDiskCache(String key, Bitmap bmp) {
    }

    @Override
    public TilesCache.State getState() {
        return this.state;
    }
}

