/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache.tmp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTileCache {
    protected static final int DEFAULT_DISK_CACHE_SIZE = 0xA00000;
    private static final char SEPARATOR = '-';
    private static final char ESCAPE_CHAR = '-';
    private final Map<Character, Character> POSSIBLY_RESERVED_CHARS = this.initPossiblyReservedChars();

    protected static File getDiskCacheDir(Context context, String subdir) {
        String cacheDirPath = context.getCacheDir().getPath();
        return new File(cacheDirPath + File.separator + subdir);
    }

    protected static int getDefaultMemoryCacheSizeKB() {
        int maxMemoryKB = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        return maxMemoryKB / 8;
    }

    protected String buildKey(String zoomifyBaseUrl, TilePositionInPyramid tilePositionInPyramid) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.escapeSpecialChars(zoomifyBaseUrl)).append('-');
        builder.append(tilePositionInPyramid.getLayer()).append('-');
        builder.append(tilePositionInPyramid.getPositionInLayer().column).append('-');
        builder.append(tilePositionInPyramid.getPositionInLayer().row);
        return builder.toString();
    }

    private String escapeSpecialChars(String zoomifyBaseUrl) {
        StringBuilder builder = new StringBuilder();
        Set<Character> keys = this.POSSIBLY_RESERVED_CHARS.keySet();
        for (int i = 0; i < zoomifyBaseUrl.length(); ++i) {
            char original = zoomifyBaseUrl.charAt(i);
            Character key = Character.valueOf(original);
            if (keys.contains(key)) {
                builder.append('-').append(this.POSSIBLY_RESERVED_CHARS.get(key));
                continue;
            }
            builder.append(original);
        }
        return builder.toString();
    }

    private Map<Character, Character> initPossiblyReservedChars() {
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        map.put(Character.valueOf('%'), Character.valueOf('a'));
        map.put(Character.valueOf('*'), Character.valueOf('b'));
        map.put(Character.valueOf('\''), Character.valueOf('c'));
        map.put(Character.valueOf('('), Character.valueOf('d'));
        map.put(Character.valueOf(')'), Character.valueOf('e'));
        map.put(Character.valueOf(';'), Character.valueOf('f'));
        map.put(Character.valueOf(':'), Character.valueOf('g'));
        map.put(Character.valueOf('@'), Character.valueOf('h'));
        map.put(Character.valueOf('&'), Character.valueOf('i'));
        map.put(Character.valueOf('='), Character.valueOf('j'));
        map.put(Character.valueOf('+'), Character.valueOf('k'));
        map.put(Character.valueOf('$'), Character.valueOf('l'));
        map.put(Character.valueOf(','), Character.valueOf('m'));
        map.put(Character.valueOf('/'), Character.valueOf('n'));
        map.put(Character.valueOf('?'), Character.valueOf('o'));
        map.put(Character.valueOf('#'), Character.valueOf('p'));
        map.put(Character.valueOf(']'), Character.valueOf('q'));
        map.put(Character.valueOf('['), Character.valueOf('r'));
        map.put(Character.valueOf('-'), Character.valueOf('s'));
        map.put(Character.valueOf('_'), Character.valueOf('t'));
        map.put(Character.valueOf('.'), Character.valueOf('u'));
        map.put(Character.valueOf('~'), Character.valueOf('v'));
        return map;
    }

    @SuppressLint(value={"NewApi"})
    protected int getBitmapSizeInKB(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount() / 1024;
        }
        return bitmap.getRowBytes() * bitmap.getHeight() / 1024;
    }

    protected byte[] bitmapToByteArray(Bitmap bitmap) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)bos);
        return bos.toByteArray();
    }
}

