/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.cache.MemoryAndDiskMetadataCache;
import cz.mzk.tiledimageview.cache.MemoryAndDiskTilesCache;
import cz.mzk.tiledimageview.cache.MetadataCache;
import cz.mzk.tiledimageview.cache.TilesCache;

public class CacheManager {
    public static final int TILE_SIZE_PX = 256;
    private static final Logger LOGGER = new Logger(CacheManager.class);
    private static TilesCache tilesCache;
    private static MetadataCache metadataCache;
    private static boolean initialized;

    public static void initialize(Context context, boolean diskCacheEnabled, boolean clearDiskCacheOnStart, long tileDiskCacheBytes) {
        if (initialized) {
            LOGGER.w("already initialized");
        } else {
            LOGGER.i("initializing");
            int memoryCacheMaxItems = CacheManager.computeMaxTilesOnScreen(context);
            tilesCache = new MemoryAndDiskTilesCache(context, memoryCacheMaxItems, diskCacheEnabled, clearDiskCacheOnStart, tileDiskCacheBytes);
            metadataCache = new MemoryAndDiskMetadataCache(context, diskCacheEnabled, clearDiskCacheOnStart);
            initialized = true;
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    @SuppressLint(value={"NewApi"})
    private static int computeMaxTilesOnScreen(Context context) {
        try {
            WindowManager wm = (WindowManager)context.getSystemService("window");
            Display display = wm.getDefaultDisplay();
            int width = 0;
            int height = 0;
            if (Build.VERSION.SDK_INT >= 13) {
                Rect rect = new Rect();
                display.getRectSize(rect);
                width = rect.width();
                height = rect.height();
            } else {
                width = display.getWidth();
                height = display.getHeight();
            }
            int columns = (int)Math.ceil(width / 256);
            int rows = (int)Math.ceil(height / 256);
            int result = rows * columns * 2;
            LOGGER.d("screen width: " + width + ", height: " + height + ", initial tiles cache size: " + result);
            return result;
        }
        catch (UnsupportedOperationException e) {
            int result = 1;
            LOGGER.w("WINDOW_SERVICE not available, returning arbitrary value " + result);
            return result;
        }
    }

    public static TilesCache getTilesCache() {
        if (!initialized) {
            throw new IllegalStateException(CacheManager.class.getSimpleName() + " has not been initialized");
        }
        return tilesCache;
    }

    public static MetadataCache getMetadataCache() {
        if (!initialized) {
            throw new IllegalStateException(CacheManager.class.getSimpleName() + " has not been initialized");
        }
        return metadataCache;
    }

    static {
        initialized = false;
    }
}

