/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache;

import android.graphics.Bitmap;
import cz.mzk.tiledimageview.ConcurrentAsyncTask;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.cache.MemoryAndDiskTilesCache;
import cz.mzk.tiledimageview.cache.TilesCache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;

public class BitmapFetchTaskRegistry {
    public static final int MAX_TASKS = 10;
    private static final Logger LOGGER = new Logger(BitmapFetchTaskRegistry.class);
    private final Map<String, FetchBitmapFromDiskAndStoreToMemoryCacheTask> tasks = new HashMap<String, FetchBitmapFromDiskAndStoreToMemoryCacheTask>();
    private final MemoryAndDiskTilesCache cache;

    public BitmapFetchTaskRegistry(MemoryAndDiskTilesCache cache) {
        this.cache = cache;
    }

    public void registerTask(String key, TilesCache.FetchingBitmapFromDiskHandler fetchedListener) {
        if (this.tasks.size() < 10) {
            boolean registered = this.tasks.containsKey(key);
            if (!registered) {
                FetchBitmapFromDiskAndStoreToMemoryCacheTask task = new FetchBitmapFromDiskAndStoreToMemoryCacheTask(this.cache, key, fetchedListener);
                this.tasks.put(key, task);
                LOGGER.v("registration performed: " + key + ": (total " + this.tasks.size() + ")");
                try {
                    task.executeConcurrentIfPossible(new Void[0]);
                }
                catch (RejectedExecutionException e) {
                    LOGGER.w("to many threads in execution pool");
                    this.unregisterTask(key);
                }
            } else {
                LOGGER.v("registration ignored: already registered: " + key + ": (total " + this.tasks.size() + ")");
            }
        } else {
            LOGGER.v("registration ignored: to many tasks: " + key + ": (total " + this.tasks.size() + ")");
        }
    }

    public void cancelAllTasks() {
        for (FetchBitmapFromDiskAndStoreToMemoryCacheTask task : this.tasks.values()) {
            task.cancel(false);
        }
    }

    private void unregisterTask(String key) {
        this.tasks.remove(key);
    }

    private class FetchBitmapFromDiskAndStoreToMemoryCacheTask
    extends ConcurrentAsyncTask<Void, Void, Void> {
        private final MemoryAndDiskTilesCache cache;
        private final String key;
        private final TilesCache.FetchingBitmapFromDiskHandler onFinishedHandler;
        private boolean success = false;

        public FetchBitmapFromDiskAndStoreToMemoryCacheTask(MemoryAndDiskTilesCache cache, String key, TilesCache.FetchingBitmapFromDiskHandler onFinishedHandler) {
            this.cache = cache;
            this.key = key;
            this.onFinishedHandler = onFinishedHandler;
        }

        protected Void doInBackground(Void ... params) {
            try {
                if (!this.isCancelled()) {
                    Bitmap fromDiskCache = this.cache.getTileFromDiskCache(this.key);
                    if (!this.isCancelled()) {
                        if (fromDiskCache != null) {
                            LOGGER.v("storing to memory cache: " + this.key);
                            this.cache.storeTileToMemoryCache(this.key, fromDiskCache);
                            this.success = true;
                        } else {
                            LOGGER.v("tile bitmap is null: " + this.key);
                            this.success = false;
                        }
                    }
                }
                return null;
            }
            catch (Throwable e) {
                LOGGER.e("error fetching tile " + this.key, e);
                return null;
            }
        }

        protected void onCancelled() {
            super.onCancelled();
            BitmapFetchTaskRegistry.this.unregisterTask(this.key);
        }

        protected void onPostExecute(Void result) {
            super.onPostExecute((Object)result);
            BitmapFetchTaskRegistry.this.unregisterTask(this.key);
            if (this.success && this.onFinishedHandler != null) {
                this.onFinishedHandler.onFetched();
            }
        }
    }
}

