/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview.cache;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.cache.CacheKeyBuilder;

public abstract class AbstractTileCache {
    private static final Logger LOGGER = new Logger(AbstractTileCache.class);

    protected String buildKey(String tileUrl) {
        String key = CacheKeyBuilder.buildKeyFromUrl(tileUrl);
        if (key.length() > 127) {
            LOGGER.w("cache key is longer then 127 characters");
        }
        return key;
    }

    @SuppressLint(value={"NewApi"})
    protected int getBitmapSizeInKB(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount() / 1024;
        }
        return bitmap.getRowBytes() * bitmap.getHeight() / 1024;
    }
}

