/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview;

import android.content.res.Resources;
import android.graphics.Rect;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.VectorD;
import java.math.BigDecimal;
import java.util.Locale;

public class Utils {
    private static final Logger LOGGER = new Logger(Utils.class);

    public static PointD computeShift(PointD pointInImageCoords, PointD pointInCanvasCoords, double imageToCanvasScaleFactor) {
        double shiftX = pointInCanvasCoords.x - pointInImageCoords.x * imageToCanvasScaleFactor;
        double shiftY = pointInCanvasCoords.y - pointInImageCoords.y * imageToCanvasScaleFactor;
        return new PointD(shiftX, shiftY);
    }

    public static double computeShiftX(double xInImageCoords, double xInCanvasCoords, double imageToCanvasScaleFactor) {
        return xInCanvasCoords - xInImageCoords * imageToCanvasScaleFactor;
    }

    public static double computeShiftY(double yInImageCoords, double yInCanvasCoords, double imageToCanvasScaleFactor) {
        return yInCanvasCoords - yInImageCoords * imageToCanvasScaleFactor;
    }

    public static double toXInImageCoords(double xInCanvasCoords, double imageToCanvasScaleFactor, double imageShiftInCanvasX) {
        return (xInCanvasCoords - imageShiftInCanvasX) / imageToCanvasScaleFactor;
    }

    public static double toYInImageCoords(double yInCanvasCoords, double imageToCanvasScaleFactor, double imageShiftInCanvasY) {
        return (yInCanvasCoords - imageShiftInCanvasY) / imageToCanvasScaleFactor;
    }

    public static double toXInCanvasCoords(double xInImageCoords, double imageToCanvasScaleFactor, double imageShiftInCanvasX) {
        return xInImageCoords * imageToCanvasScaleFactor + imageShiftInCanvasX;
    }

    public static double toYInCanvasCoords(double yInImageCoords, double imageToCanvasScaleFactor, double imageShiftInCanvasY) {
        return yInImageCoords * imageToCanvasScaleFactor + imageShiftInCanvasY;
    }

    public static PointD toImageCoords(PointD pointInCanvasCoords, double imageToCanvasScaleFactor, VectorD imageShiftInCanvas) {
        double imageX = (pointInCanvasCoords.x - imageShiftInCanvas.x) / imageToCanvasScaleFactor;
        double imageY = (pointInCanvasCoords.y - imageShiftInCanvas.y) / imageToCanvasScaleFactor;
        return new PointD(imageX, imageY);
    }

    public static PointD toCanvasCoords(PointD pointInImageCoords, double imageToCanvasScaleFactor, VectorD imageShiftInCanvas) {
        double canvasX = pointInImageCoords.x * imageToCanvasScaleFactor + imageShiftInCanvas.x;
        double canvasY = pointInImageCoords.y * imageToCanvasScaleFactor + imageShiftInCanvas.y;
        PointD result = new PointD(canvasX, canvasY);
        return result;
    }

    public static Rect toImageCoords(Rect rectInCanvasCoords, double imageToCanvasScaleFactor, VectorD imageShiftInCanvas) {
        double left = ((double)rectInCanvasCoords.left - imageShiftInCanvas.x) / imageToCanvasScaleFactor;
        double top = ((double)rectInCanvasCoords.top - imageShiftInCanvas.y) / imageToCanvasScaleFactor;
        double right = ((double)rectInCanvasCoords.right - imageShiftInCanvas.x) / imageToCanvasScaleFactor;
        double bottom = ((double)rectInCanvasCoords.bottom - imageShiftInCanvas.y) / imageToCanvasScaleFactor;
        return new Rect((int)left, (int)top, (int)right, (int)bottom);
    }

    public static Rect toCanvasCoords(Rect rectInImageCoords, double imageToCanvasScaleFactor, VectorD imageShiftInCanvas) {
        double left = (double)rectInImageCoords.left * imageToCanvasScaleFactor + imageShiftInCanvas.x;
        double top = (double)rectInImageCoords.top * imageToCanvasScaleFactor + imageShiftInCanvas.y;
        double right = (double)rectInImageCoords.right * imageToCanvasScaleFactor + imageShiftInCanvas.x;
        double bottom = (double)rectInImageCoords.bottom * imageToCanvasScaleFactor + imageShiftInCanvas.y;
        return new Rect((int)left, (int)top, (int)right, (int)bottom);
    }

    public static String toString(Rect rect) {
        return Utils.toString(rect, "px");
    }

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static double dpToPx(double dp) {
        return dp * (double)Resources.getSystem().getDisplayMetrics().density;
    }

    public static int pxToDp(int px) {
        return (int)((float)px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static double pxToDp(double px) {
        return px / (double)Resources.getSystem().getDisplayMetrics().density;
    }

    public static int pow(int x, int power) {
        int result = 1;
        for (int i = 1; i <= power; ++i) {
            result *= x;
        }
        return result;
    }

    public static double logarithm(double x, double base) {
        return Math.log(x) / Math.log(base);
    }

    public static float round(float d, int decimals) {
        BigDecimal bd = new BigDecimal(Float.toString(d));
        bd = bd.setScale(decimals, 4);
        return bd.floatValue();
    }

    public static String formatBytes(long cacheSizeBytes) {
        if (cacheSizeBytes < 1024L) {
            return String.format(Locale.US, "%d B", cacheSizeBytes);
        }
        if (cacheSizeBytes < 0x100000L) {
            long kB = cacheSizeBytes / 1024L;
            return String.format(Locale.US, "%d kB", kB);
        }
        if (cacheSizeBytes < 0x40000000L) {
            long MB = cacheSizeBytes / 0x100000L;
            return String.format(Locale.US, "%d MB", MB);
        }
        long GB = cacheSizeBytes / 0x40000000L;
        return String.format(Locale.US, "%d GB", GB);
    }

    public static String toString(Rect rect, String unit) {
        StringBuilder builder = new StringBuilder();
        builder.append("horizontal: ").append(rect.left).append("-").append(rect.right).append(" (").append(rect.width()).append(' ').append(unit).append(')');
        builder.append(", ");
        builder.append("vertical: ").append(rect.top).append("-").append(rect.bottom).append(" (").append(rect.height()).append(' ').append(unit).append(')');
        return builder.toString();
    }

    public static String coordsToString(int[] coords) {
        return "[" + coords[0] + ',' + coords[1] + ']';
    }

    public static int collapseToInterval(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }
}

