/*
 * Decompiled with CFR 0.152.
 */
package cz.mzk.tiledimageview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import cz.mzk.tiledimageview.Logger;
import cz.mzk.tiledimageview.PointD;
import cz.mzk.tiledimageview.R;
import cz.mzk.tiledimageview.TiledImageViewApi;
import cz.mzk.tiledimageview.Utils;
import cz.mzk.tiledimageview.VectorD;
import cz.mzk.tiledimageview.cache.CacheManager;
import cz.mzk.tiledimageview.cache.TileBitmap;
import cz.mzk.tiledimageview.cache.TilesCache;
import cz.mzk.tiledimageview.dev.DevLoggers;
import cz.mzk.tiledimageview.dev.DevPoints;
import cz.mzk.tiledimageview.dev.DevTools;
import cz.mzk.tiledimageview.gestures.MyGestureListener;
import cz.mzk.tiledimageview.images.ImageManager;
import cz.mzk.tiledimageview.images.TilePositionInPyramid;
import cz.mzk.tiledimageview.images.TiledImageProtocol;
import cz.mzk.tiledimageview.images.zoomify.ZoomifyImageManager;
import cz.mzk.tiledimageview.rectangles.FramingRectangle;
import cz.mzk.tiledimageview.rectangles.FramingRectangleDrawer;
import java.util.List;

public class TiledImageView
extends View
implements TiledImageViewApi {
    public static final boolean DEV_MODE = false;
    private static final Logger LOGGER = new Logger(TiledImageView.class);
    boolean mMinZoomCanvasImagePaddingInitialized = false;
    private double mCanvasImagePaddingHorizontal = -1.0;
    private double mCanvasImagePaddingVertical = -1.0;
    private Rect mWholeImageAreaInCanvasCoords = null;
    private Rect mVisibleImageAreaInCanvas = null;
    private boolean mViewmodeScaleFactorsInitialized = false;
    private boolean mViewmodeShiftInitialized = false;
    private VectorD mViewmodeShift = VectorD.ZERO_VECTOR;
    private boolean mDrawLayerWithWorseResolution = true;
    private double mInitialScaleFactor = -1.0;
    private double mMinScaleFactor = -1.0;
    private double mMaxScaleFactor = -1.0;
    private ViewMode mViewMode = ViewMode.FIT_TO_SCREEN;
    private String mZoomifyBaseUrl;
    private ImageManager mImageManager;
    private MetadataInitializationHandler mMetadataInitializationHandler;
    private TileDownloadErrorListener mTileDownloadErrorListener;
    private MyGestureListener mGestureListener;
    private SingleTapListener mSingleTapListener;
    private FramingRectangleDrawer mFramingRectDrawer;
    private DevTools mDevTools = null;
    private DevPoints mTestPoints = null;

    public TiledImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initCache(context);
        this.init(context);
    }

    public TiledImageView(Context context) {
        super(context);
        this.initCache(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mGestureListener = new MyGestureListener(context, this, this.mDevTools);
        this.mFramingRectDrawer = new FramingRectangleDrawer(context);
    }

    private void initCache(Context context) {
        if (!CacheManager.isInitialized()) {
            Resources res = context.getResources();
            boolean diskCacheEnabled = res.getBoolean(R.bool.tiledimageview_disk_cache_enabled);
            boolean clearDiskCacheOnStart = res.getBoolean(R.bool.tiledimageview_disk_cache_clear_in_initialization);
            long tileDiskCacheBytes = res.getInteger(R.integer.tiledimageview_tile_disk_cache_size_kb) * 1024;
            CacheManager.initialize(context, diskCacheEnabled, clearDiskCacheOnStart, tileDiskCacheBytes);
        }
    }

    private void logDeviceScreenCategory() {
        String screenType = this.getResources().getString(R.string.tiledimageview_screen_type);
        DevLoggers.DISPLAY.d("screen type: " + screenType);
        double pixelRatio = (double)this.getResources().getInteger(R.integer.tiledimageview_pxRatio) / 100.0;
        DevLoggers.DISPLAY.d(String.format("pxRatio: %.2f", pixelRatio));
    }

    @SuppressLint(value={"NewApi"})
    private void logHwAcceleration() {
        if (Build.VERSION.SDK_INT >= 11) {
            DevLoggers.DISPLAY.d("(Window) HW accelerated: " + this.isHardwareAccelerated());
        }
    }

    @Override
    public ViewMode getViewMode() {
        return this.mViewMode;
    }

    @Override
    public void setViewMode(ViewMode viewMode) {
        if (viewMode == null) {
            throw new NullPointerException();
        }
        this.mViewMode = viewMode;
    }

    @Override
    public void setMetadataInitializationHandler(MetadataInitializationHandler metadataInitializationHandler) {
        this.mMetadataInitializationHandler = metadataInitializationHandler;
    }

    @Override
    public void setTileDownloadErrorListener(TileDownloadErrorListener tileDownloadErrorListener) {
        this.mTileDownloadErrorListener = tileDownloadErrorListener;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelAllTasks();
        this.mGestureListener = null;
        this.mSingleTapListener = null;
        this.mDevTools = null;
        this.mImageManager = null;
        this.mMetadataInitializationHandler = null;
        this.mTileDownloadErrorListener = null;
    }

    private void cancelAllTasks() {
        if (this.mImageManager != null) {
            this.mImageManager.cancelAllTasks();
        }
        if (CacheManager.getTilesCache() != null) {
            CacheManager.getTilesCache().cancelAllTasks();
        }
        if (this.mGestureListener != null) {
            this.mGestureListener.stopAllAnimations();
        }
    }

    @Override
    public void loadImage(TiledImageProtocol tiledImageProtocol, String baseUrl) {
        LOGGER.d("loading new image, base url: " + baseUrl);
        this.mViewmodeScaleFactorsInitialized = false;
        this.mViewmodeShiftInitialized = false;
        this.mMinZoomCanvasImagePaddingInitialized = false;
        this.mZoomifyBaseUrl = baseUrl;
        this.cancelAllTasks();
        this.mGestureListener.reset();
        double pxRatio = (double)this.getResources().getInteger(R.integer.tiledimageview_pxRatio) / 100.0;
        this.mImageManager = new ZoomifyImageManager(this.mZoomifyBaseUrl, pxRatio);
        this.initTilesDownloaderAsync();
    }

    @Override
    public void setFramingRectangles(List<FramingRectangle> framingRectangles) {
        this.mFramingRectDrawer.setFrameRectangles(framingRectangles);
        this.invalidate();
    }

    private void initTilesDownloaderAsync() {
        this.mImageManager.enqueueMetadataInitialization(this.mMetadataInitializationHandler, new MetadataInitializationSuccessListener(){

            @Override
            public void onMetadataDownloaded(ImageManager imgManager) {
                LOGGER.d("ImageManager initialized");
                if (imgManager.equals(TiledImageView.this.mImageManager)) {
                    TiledImageView.this.invalidate();
                }
            }
        });
    }

    public void onDraw(Canvas canv) {
        if (this.mDevTools != null) {
            this.mDevTools.setCanvas(canv);
            this.mDevTools.fillWholeCanvasWithColor(this.mDevTools.getPaintYellow());
        }
        if (this.mImageManager.isInitialized()) {
            if (this.mDevTools != null) {
                this.mDevTools.fillWholeCanvasWithColor(this.mDevTools.getPaintBlue());
            }
            if (!this.mViewmodeScaleFactorsInitialized) {
                this.initViewmodeScaleFactors(canv);
                this.mViewmodeScaleFactorsInitialized = true;
            }
            if (!this.mViewmodeShiftInitialized) {
                this.initViewmodeShift(canv);
                this.mViewmodeShiftInitialized = true;
            }
            if (!this.mMinZoomCanvasImagePaddingInitialized) {
                this.initMinZoomPadding(canv);
                this.mMinZoomCanvasImagePaddingInitialized = true;
            }
            this.mWholeImageAreaInCanvasCoords = this.computeWholeImageAreaInCanvasCoords(this.getTotalScaleFactor(), this.getTotalShift());
            if (this.mDevTools != null) {
                this.mDevTools.fillRectAreaWithColor(this.mWholeImageAreaInCanvasCoords, this.mDevTools.getPaintRedTrans());
            }
            this.mVisibleImageAreaInCanvas = this.computeVisibleImageAreaInCanvas(canv);
            if (this.mDevTools != null) {
                this.mDevTools.fillRectAreaWithColor(this.mVisibleImageAreaInCanvas, this.mDevTools.getPaintGreenTrans());
            }
            int bestLayerId = this.mImageManager.computeBestLayerId(this.mWholeImageAreaInCanvasCoords);
            this.drawLayers(canv, bestLayerId, true, this.calculateVisibleAreaInImageCoords());
            if (this.mFramingRectDrawer != null) {
                this.mFramingRectDrawer.setCanvas(canv);
                this.mFramingRectDrawer.draw(this.getTotalScaleFactor(), this.getTotalShift());
            }
            if (this.mDevTools != null) {
                double totalScaleFactor = this.getTotalScaleFactor();
                VectorD totalShift = this.getTotalShift();
                this.mDevTools.drawImageCoordPoints(this.mTestPoints, totalScaleFactor, totalShift);
                this.mDevTools.drawTileRectStack();
            }
        }
    }

    private void initViewmodeScaleFactors(Canvas canv) {
        int imgWidth = this.mImageManager.getImageWidth();
        int imgHeight = this.mImageManager.getImageHeight();
        double scaleFactorFitToScreen = this.computeScaleFactorFitToScreen(canv.getWidth(), canv.getHeight(), imgWidth, imgHeight);
        double scaleFactorNoFreeSpace = this.computeScaleFactorNoFreeSpace(canv.getWidth(), canv.getHeight(), imgWidth, imgHeight);
        switch (this.mViewMode) {
            case FIT_TO_SCREEN: {
                this.mInitialScaleFactor = scaleFactorFitToScreen;
                break;
            }
            default: {
                this.mInitialScaleFactor = scaleFactorNoFreeSpace;
            }
        }
        this.mMinScaleFactor = Math.min(scaleFactorFitToScreen, scaleFactorNoFreeSpace);
        int mustFitInCanvasObjectWidthPx = this.mImageManager.getTileTypicalSize();
        int mustFitInCanvasObjectHeightPx = this.mImageManager.getTileTypicalSize();
        double maxWidthScalePx = (double)canv.getWidth() / (double)mustFitInCanvasObjectWidthPx;
        double maxHeightScalePx = (double)canv.getHeight() / (double)mustFitInCanvasObjectHeightPx;
        this.mMaxScaleFactor = Math.min(maxWidthScalePx, maxHeightScalePx);
    }

    private PointD computeVisibleImageCenter() {
        float x = this.mVisibleImageAreaInCanvas.width() / 2 + this.mVisibleImageAreaInCanvas.left;
        float y = this.mVisibleImageAreaInCanvas.height() / 2 + this.mVisibleImageAreaInCanvas.top;
        return new PointD(x, y);
    }

    @Override
    public double getCanvasImagePaddingHorizontal() {
        return this.mCanvasImagePaddingHorizontal;
    }

    @Override
    public double getCanvasImagePaddingVertical() {
        return this.mCanvasImagePaddingVertical;
    }

    @Override
    public VectorD getTotalShift() {
        VectorD gestureShifts = this.mGestureListener.getTotalShift();
        return this.mViewmodeShift.plus(gestureShifts);
    }

    @Override
    public double getTotalScaleFactor() {
        return this.mInitialScaleFactor * this.mGestureListener.getTotalScaleFactor();
    }

    @Override
    public double getMinScaleFactor() {
        return this.mMinScaleFactor;
    }

    @Override
    public double getMaxScaleFactor() {
        return this.mMaxScaleFactor;
    }

    private void drawLayers(Canvas canv, int highestLayer, boolean isIdealLayer, Rect visibleAreaInImageCoords) {
        List<TilePositionInPyramid> visibleTiles = this.mImageManager.getVisibleTilesForLayer(highestLayer, visibleAreaInImageCoords);
        this.mImageManager.cancelFetchingATilesForLayerExeptForThese(highestLayer, visibleTiles);
        if (isIdealLayer && CacheManager.getTilesCache() != null) {
            int minCacheSize = visibleTiles.size() * 2;
            CacheManager.getTilesCache().updateMemoryCacheSizeInItems(minCacheSize);
        }
        boolean allTilesAvailable = true;
        for (TilePositionInPyramid visibleTile : visibleTiles) {
            boolean tileAccessible = CacheManager.getTilesCache().containsTileInMemory(this.mImageManager.buildTileUrl(visibleTile));
            if (tileAccessible) continue;
            allTilesAvailable = false;
            break;
        }
        if (!allTilesAvailable && highestLayer != 0 && this.mDrawLayerWithWorseResolution) {
            this.drawLayers(canv, highestLayer - 1, false, visibleAreaInImageCoords);
        }
        for (TilePositionInPyramid visibleTile : visibleTiles) {
            this.fetchTileWithoutBlockingOnDiskRead(canv, visibleTile);
        }
    }

    private void fetchTileWithoutBlockingOnDiskRead(Canvas canv, TilePositionInPyramid visibleTileId) {
        TileBitmap tile = CacheManager.getTilesCache().getTileAsync(this.mImageManager.buildTileUrl(visibleTileId), new TilesCache.FetchingBitmapFromDiskHandler(){

            @Override
            public void onFetched() {
                TiledImageView.this.invalidate();
            }
        });
        switch (tile.getState()) {
            case IN_MEMORY: {
                this.drawTile(canv, visibleTileId, tile.getBitmap());
                break;
            }
            case IN_DISK: {
                break;
            }
            case NOT_FOUND: {
                this.mImageManager.enqueTileDownload(visibleTileId, this.mTileDownloadErrorListener, new TileDownloadSuccessListener(){

                    @Override
                    public void onTileDownloaded() {
                        TiledImageView.this.invalidate();
                    }
                });
            }
        }
    }

    private void drawTile(Canvas canv, TilePositionInPyramid tileId, Bitmap tileBmp) {
        Rect tileInCanvas = this.toTileAreaInCanvas(tileId, tileBmp);
        canv.drawBitmap(tileBmp, null, tileInCanvas, null);
        if (this.mDevTools != null) {
            this.mDevTools.highlightTile(tileInCanvas, this.mDevTools.getPaintRed());
        }
    }

    private Rect calculateVisibleAreaInImageCoords() {
        double resizeFactor = this.getTotalScaleFactor();
        VectorD totalShift = this.getTotalShift();
        return Utils.toImageCoords(this.mVisibleImageAreaInCanvas, resizeFactor, totalShift);
    }

    private void setDrawLayerWithWorseResolution(boolean show) {
        this.mDrawLayerWithWorseResolution = show;
    }

    private Rect toTileAreaInCanvas(TilePositionInPyramid tilePositionInPyramid, Bitmap tile) {
        Rect tileAreaInImageCoords = this.mImageManager.getTileAreaInImageCoords(tilePositionInPyramid);
        return Utils.toCanvasCoords(tileAreaInImageCoords, this.getTotalScaleFactor(), this.getTotalShift());
    }

    private double computeScaleFactorFitToScreen(double canvasWidth, double canvasHeight, double imgOriginalWidth, double imgOriginalHeight) {
        double widthRatio = canvasWidth / imgOriginalWidth;
        double heightRatio = canvasHeight / imgOriginalHeight;
        if (widthRatio < 1.0 && heightRatio < 1.0) {
            return widthRatio < heightRatio ? widthRatio : heightRatio;
        }
        if (widthRatio < 1.0) {
            return widthRatio;
        }
        if (heightRatio < 1.0) {
            return heightRatio;
        }
        return widthRatio < heightRatio ? widthRatio : heightRatio;
    }

    private double computeScaleFactorNoFreeSpace(double canvasWidth, double canvasHeight, double imgOriginalWidth, double imgOriginalHeight) {
        double widthRatio = canvasWidth / imgOriginalWidth;
        double heightRatio = canvasHeight / imgOriginalHeight;
        if (widthRatio < 1.0 && heightRatio < 1.0) {
            return widthRatio < heightRatio ? heightRatio : widthRatio;
        }
        if (heightRatio > 1.0) {
            return heightRatio;
        }
        if (widthRatio > 1.0) {
            return widthRatio;
        }
        return widthRatio > heightRatio ? widthRatio : heightRatio;
    }

    private void initViewmodeShift(Canvas canv) {
        double canvasWidth = canv.getWidth();
        double canvasHeight = canv.getHeight();
        double imageOriginalWidth = this.mImageManager.getImageWidth();
        double imageOriginalHeight = this.mImageManager.getImageHeight();
        double actualWidth = imageOriginalWidth * this.mInitialScaleFactor;
        double actualHeight = imageOriginalHeight * this.mInitialScaleFactor;
        double extraSpaceWidthCanv = canvasWidth - actualWidth;
        double extraSpaceHeightCanv = canvasHeight - actualHeight;
        double xLeft = 0.0;
        double xCenter = extraSpaceWidthCanv / 2.0;
        double xRight = extraSpaceWidthCanv;
        double yTop = 0.0;
        double yCenter = extraSpaceHeightCanv / 2.0;
        double yBottom = extraSpaceHeightCanv;
        switch (this.mViewMode) {
            case FIT_TO_SCREEN: {
                this.mViewmodeShift = new VectorD(xCenter, yCenter);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_LEFT_VERTICAL_TOP: {
                this.mViewmodeShift = new VectorD(xLeft, yTop);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_LEFT_VERTICAL_CENTER: {
                this.mViewmodeShift = new VectorD(xLeft, yCenter);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_LEFT_VERTICAL_BOTTOM: {
                this.mViewmodeShift = new VectorD(xLeft, yBottom);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_CENTER_VERTICAL_TOP: {
                this.mViewmodeShift = new VectorD(xCenter, yTop);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_CENTER_VERTICAL_CENTER: {
                this.mViewmodeShift = new VectorD(xCenter, yCenter);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_CENTER_VERTICAL_BOTTOM: {
                this.mViewmodeShift = new VectorD(xCenter, yBottom);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_RIGHT_VERTICAL_TOP: {
                this.mViewmodeShift = new VectorD(xRight, yTop);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_RIGHT_VERTICAL_CENTER: {
                this.mViewmodeShift = new VectorD(xRight, yCenter);
                break;
            }
            case NO_FREE_SPACE_ALIGN_HORIZONTAL_RIGHT_VERTICAL_BOTTOM: {
                this.mViewmodeShift = new VectorD(xRight, yBottom);
            }
        }
        DevLoggers.CENTERS.d("initial shift:" + this.mViewmodeShift);
    }

    private void initMinZoomPadding(Canvas canv) {
        PointD imgBottomRight = new PointD(this.mImageManager.getImageWidth(), this.mImageManager.getImageHeight());
        PointD imgInCanvasBottomRight = Utils.toCanvasCoords(imgBottomRight, this.mMinScaleFactor, VectorD.ZERO_VECTOR);
        double freeWidth = ((double)canv.getWidth() - imgInCanvasBottomRight.x) * 0.5;
        double freeHeight = ((double)canv.getHeight() - imgInCanvasBottomRight.y) * 0.5;
        this.mCanvasImagePaddingHorizontal = Utils.toXInImageCoords(freeWidth, this.mMinScaleFactor, 0.0);
        this.mCanvasImagePaddingVertical = Utils.toYInImageCoords(freeHeight, this.mMinScaleFactor, 0.0);
    }

    private Rect computeWholeImageAreaInCanvasCoords(double scaleFactor, VectorD shift) {
        Rect imgArea = new Rect(0, 0, this.mImageManager.getImageWidth(), this.mImageManager.getImageHeight());
        return Utils.toCanvasCoords(imgArea, scaleFactor, shift);
    }

    private Rect computeVisibleImageAreaInCanvas(Canvas canv) {
        int left = this.mapNumberToInterval(this.mWholeImageAreaInCanvasCoords.left, 0, canv.getWidth());
        int right = this.mapNumberToInterval(this.mWholeImageAreaInCanvasCoords.right, 0, canv.getWidth());
        int top = this.mapNumberToInterval(this.mWholeImageAreaInCanvasCoords.top, 0, canv.getHeight());
        int bottom = this.mapNumberToInterval(this.mWholeImageAreaInCanvasCoords.bottom, 0, canv.getHeight());
        return new Rect(left, top, right, bottom);
    }

    private int mapNumberToInterval(int number, int min, int max) {
        if (number <= min) {
            return min;
        }
        if (number >= max) {
            return max;
        }
        return number;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mGestureListener.onTouchEvent(event);
    }

    @Override
    public SingleTapListener getSingleTapListener() {
        return this.mSingleTapListener;
    }

    @Override
    public void setSingleTapListener(SingleTapListener singleTapListener) {
        this.mSingleTapListener = singleTapListener;
    }

    @Override
    public Rect getVisibleImageAreaInCanvas() {
        return this.mVisibleImageAreaInCanvas;
    }

    @Override
    public double getInitialScaleFactor() {
        return this.mInitialScaleFactor;
    }

    @Override
    public int getImageWidth() {
        return this.mImageManager.getImageWidth();
    }

    @Override
    public int getImageHeight() {
        return this.mImageManager.getImageHeight();
    }

    public static interface MetadataInitializationSuccessListener {
        public void onMetadataDownloaded(ImageManager var1);
    }

    public static interface TileDownloadSuccessListener {
        public void onTileDownloaded();
    }

    public static interface TileDownloadErrorListener {
        public void onTileUnhandableResponse(String var1, int var2);

        public void onTileRedirectionLoop(String var1, int var2);

        public void onTileDataTransferError(String var1, String var2);

        public void onTileInvalidDataError(String var1, String var2);
    }

    public static interface MetadataInitializationHandler {
        public void onMetadataInitialized();

        public void onMetadataUnhandableResponseCode(String var1, int var2);

        public void onMetadataRedirectionLoop(String var1, int var2);

        public void onMetadataDataTransferError(String var1, String var2);

        public void onMetadataInvalidData(String var1, String var2);
    }

    public static interface SingleTapListener {
        public void onSingleTap(float var1, float var2, Rect var3);
    }

    public static enum ViewMode {
        FIT_TO_SCREEN,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_LEFT_VERTICAL_TOP,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_LEFT_VERTICAL_CENTER,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_LEFT_VERTICAL_BOTTOM,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_CENTER_VERTICAL_TOP,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_CENTER_VERTICAL_CENTER,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_CENTER_VERTICAL_BOTTOM,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_RIGHT_VERTICAL_TOP,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_RIGHT_VERTICAL_CENTER,
        NO_FREE_SPACE_ALIGN_HORIZONTAL_RIGHT_VERTICAL_BOTTOM;

    }
}

