/*
 * Decompiled with CFR 0.152.
 */
package cz.koto.keystorecompat;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import com.scottyab.rootbeer.RootBeer;
import com.scottyab.rootbeer.util.Utils;
import cz.koto.keystorecompat.KeystoreCompat;
import cz.koto.keystorecompat.KeystoreCompatConfig;
import cz.koto.keystorecompat.compat.KeystoreCompatFacade;
import cz.koto.keystorecompat.compat.KeystoreCompatImpl;
import cz.koto.keystorecompat.exception.EncryptionNotAllowedException;
import cz.koto.keystorecompat.exception.ForceLockScreenMarshmallowException;
import cz.koto.keystorecompat.exception.KeystoreCompatException;
import cz.koto.keystorecompat.utility.IntPrefDelegate;
import cz.koto.keystorecompat.utility.PrefDelegate;
import cz.koto.keystorecompat.utility.PrefDelegateKt;
import cz.koto.keystorecompat.utility.StringPrefDelegate;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u0004H\u0002J\u0006\u00100\u001a\u00020-J\u0006\u00101\u001a\u00020\u001fJ\u0006\u00102\u001a\u00020-J\u0015\u00103\u001a\u00020-2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b7J\b\u00108\u001a\u00020\u001fH\u0002J\u0010\u00109\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010:\u001a\u00020\u001fJ\u0006\u0010;\u001a\u00020\u001fJk\u0010<\u001a\u00020-2!\u0010=\u001a\u001d\u0012\u0013\u0012\u00110?\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(B\u0012\u0004\u0012\u00020-0>2%\u0010C\u001a!\u0012\u0017\u0012\u00150Dj\u0002`E\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020-0>2\b\u0010G\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010H\u001a\u00020\u001fH\u0007\u00a2\u0006\u0002\u0010IJk\u0010J\u001a\u00020-2!\u0010=\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(B\u0012\u0004\u0012\u00020-0>2%\u0010C\u001a!\u0012\u0017\u0012\u00150Dj\u0002`E\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020-0>2\b\u0010G\u001a\u0004\u0018\u00010\u001f2\b\b\u0002\u0010H\u001a\u00020\u001fH\u0007\u00a2\u0006\u0002\u0010IJ\r\u0010K\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\bLJ\u0006\u0010M\u001a\u00020-J\b\u0010N\u001a\u00020-H\u0002J\u001d\u0010O\u001a\u00020-\"\b\b\u0000\u0010P*\u00020\f2\u0006\u0010\u000b\u001a\u0002HP\u00a2\u0006\u0002\u0010\u0010JK\u0010Q\u001a\u00020-2\u0006\u0010R\u001a\u00020?2!\u0010S\u001a\u001d\u0012\u0013\u0012\u00110T\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020-0>2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020-0U2\b\b\u0002\u0010V\u001a\u00020\u001fH\u0007JK\u0010Q\u001a\u00020-2\u0006\u0010R\u001a\u00020\u00042!\u0010S\u001a\u001d\u0012\u0013\u0012\u00110T\u00a2\u0006\f\b@\u0012\b\bA\u0012\u0004\b\b(F\u0012\u0004\u0012\u00020-0>2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020-0U2\b\b\u0002\u0010V\u001a\u00020\u001fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R;\u0010\u0018\u001a\n \b*\u0004\u0018\u00010\u00040\u00042\u000e\u0010\u0017\u001a\n \b*\u0004\u0018\u00010\u00040\u00048B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0019\u0010\u0006\"\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010$\u001a\u00020#2\u0006\u0010\u0017\u001a\u00020#8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u000e\u0010+\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lcz/koto/keystorecompat/KeystoreCompat;", "", "()V", "KEYSTORE_KEYWORD", "", "getKEYSTORE_KEYWORD", "()Ljava/lang/String;", "LOG_TAG", "kotlin.jvm.PlatformType", "certSubject", "Ljavax/security/auth/x500/X500Principal;", "config", "Lcz/koto/keystorecompat/KeystoreCompatConfig;", "getConfig", "()Lcz/koto/keystorecompat/KeystoreCompatConfig;", "setConfig", "(Lcz/koto/keystorecompat/KeystoreCompatConfig;)V", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "<set-?>", "encryptedSecret", "getEncryptedSecret", "setEncryptedSecret", "(Ljava/lang/String;)V", "encryptedSecret$delegate", "Lcz/koto/keystorecompat/utility/StringPrefDelegate;", "isRooted", "", "Ljava/lang/Boolean;", "keyStore", "Ljava/security/KeyStore;", "", "lockScreenCancelCount", "getLockScreenCancelCount", "()I", "setLockScreenCancelCount", "(I)V", "lockScreenCancelCount$delegate", "Lcz/koto/keystorecompat/utility/IntPrefDelegate;", "uniqueId", "clearCredentials", "", "createNewKeyPair", "aliasText", "deactivate", "hasSecretLoadable", "increaseLockScreenCancel", "init", "init$android_keystore_compat_release", "initKeyPairIfNecessary", "alias", "initKeyPairIfNecessary$android_keystore_compat_release", "isCertificateValid", "isDeviceRooted", "isKeystoreCompatAvailable", "isSecurityEnabled", "loadSecret", "onSuccess", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "cre", "onFailure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "e", "forceFlag", "isBase64Encoded", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/lang/Boolean;Z)V", "loadSecretAsString", "lockScreenCancelled", "lockScreenCancelled$android_keystore_compat_release", "lockScreenSuccessful", "logUnsupportedVersionForKeystore", "overrideConfig", "T", "storeSecret", "secret", "onError", "Lcz/koto/keystorecompat/exception/KeystoreCompatException;", "Lkotlin/Function0;", "useBase64Encoding", "android-keystore-compat_release"})
@TargetApi(value=19)
public final class KeystoreCompat {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    public static Context context;
    @NotNull
    public static KeystoreCompatConfig config;
    @NotNull
    private static final String KEYSTORE_KEYWORD = "AndroidKeyStore";
    private static KeyStore keyStore;
    private static X500Principal certSubject;
    private static String uniqueId;
    private static Boolean isRooted;
    private static final String LOG_TAG;
    private static final StringPrefDelegate encryptedSecret$delegate;
    private static final IntPrefDelegate lockScreenCancelCount$delegate;
    public static final KeystoreCompat INSTANCE;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KeystoreCompat.class), "encryptedSecret", "getEncryptedSecret()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(KeystoreCompat.class), "lockScreenCancelCount", "getLockScreenCancelCount()I"))};
        new KeystoreCompat();
    }

    @NotNull
    public final Context getContext() {
        Context context = KeystoreCompat.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        return context;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"<set-?>");
        KeystoreCompat.context = context;
    }

    @NotNull
    public final KeystoreCompatConfig getConfig() {
        KeystoreCompatConfig keystoreCompatConfig = config;
        if (keystoreCompatConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        return keystoreCompatConfig;
    }

    public final void setConfig(@NotNull KeystoreCompatConfig keystoreCompatConfig) {
        Intrinsics.checkParameterIsNotNull((Object)keystoreCompatConfig, (String)"<set-?>");
        config = keystoreCompatConfig;
    }

    @NotNull
    public final String getKEYSTORE_KEYWORD() {
        return KEYSTORE_KEYWORD;
    }

    private final String getEncryptedSecret() {
        return encryptedSecret$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setEncryptedSecret(String string) {
        encryptedSecret$delegate.setValue((Object)this, $$delegatedProperties[0], string);
    }

    private final int getLockScreenCancelCount() {
        return (Integer)lockScreenCancelCount$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setLockScreenCancelCount(int n) {
        lockScreenCancelCount$delegate.setValue((Object)this, $$delegatedProperties[1], n);
    }

    public final <T extends KeystoreCompatConfig> void overrideConfig(@NotNull T config) {
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        KeystoreCompat.config = config;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isKeystoreCompatAvailable() {
        if (Build.VERSION.SDK_INT >= 19) {
            Context context = KeystoreCompat.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            }
            if (!this.isDeviceRooted(context)) {
                return true;
            }
        }
        boolean bl = false;
        boolean ret = bl;
        if (ret) return ret;
        this.logUnsupportedVersionForKeystore();
        return ret;
    }

    public final boolean isSecurityEnabled() {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        KeystoreCompatFacade keystoreCompatFacade = KeystoreCompatImpl.INSTANCE.getKeystoreCompat();
        Context context = KeystoreCompat.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        return keystoreCompatFacade.isSecurityEnabled(context);
    }

    @JvmOverloads
    public final void storeSecret(@NotNull byte[] secret, @NotNull Function1<? super KeystoreCompatException, Unit> onError, @NotNull Function0<Unit> onSuccess, boolean useBase64Encoding) {
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        if (Build.VERSION.SDK_INT >= 19) {
            Log.d((String)KeystoreCompat.access$getLOG_TAG$p(INSTANCE), (String)"Before load KeyPair...");
            if (INSTANCE.isKeystoreCompatAvailable() && INSTANCE.isSecurityEnabled()) {
                INSTANCE.initKeyPairIfNecessary$android_keystore_compat_release(KeystoreCompat.access$getUniqueId$p(INSTANCE));
                try {
                    KeyStore.Entry entry = KeystoreCompat.access$getKeyStore$p(INSTANCE).getEntry(KeystoreCompat.access$getUniqueId$p(INSTANCE), null);
                    if (entry == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.Entry");
                    }
                    KeystoreCompat.INSTANCE.setEncryptedSecret(KeystoreCompatImpl.INSTANCE.getKeystoreCompat().storeSecret(secret, entry, useBase64Encoding));
                    onSuccess.invoke();
                }
                catch (ForceLockScreenMarshmallowException fle) {
                    INSTANCE.clearCredentials();
                    onError.invoke((Object)fle);
                }
                catch (Exception e) {
                    INSTANCE.clearCredentials();
                    throw (Throwable)e;
                }
            } else {
                onError.invoke((Object)new EncryptionNotAllowedException(INSTANCE.isKeystoreCompatAvailable(), INSTANCE.isSecurityEnabled()));
            }
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void storeSecret$default(KeystoreCompat keystoreCompat, byte[] byArray, Function1 function1, Function0 function0, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        keystoreCompat.storeSecret(byArray, (Function1<? super KeystoreCompatException, Unit>)function1, (Function0<Unit>)function0, bl);
    }

    @JvmOverloads
    public final void storeSecret(@NotNull byte[] secret, @NotNull Function1<? super KeystoreCompatException, Unit> onError, @NotNull Function0<Unit> onSuccess) {
        KeystoreCompat.storeSecret$default(this, secret, onError, onSuccess, false, 8, null);
    }

    @JvmOverloads
    public final void storeSecret(@NotNull String secret, @NotNull Function1<? super KeystoreCompatException, Unit> onError, @NotNull Function0<Unit> onSuccess, boolean useBase64Encoding) {
        Intrinsics.checkParameterIsNotNull((Object)secret, (String)"secret");
        Intrinsics.checkParameterIsNotNull(onError, (String)"onError");
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        if (Build.VERSION.SDK_INT >= 19) {
            Log.d((String)KeystoreCompat.access$getLOG_TAG$p(INSTANCE), (String)"Before load KeyPair...");
            if (INSTANCE.isKeystoreCompatAvailable() && INSTANCE.isSecurityEnabled()) {
                INSTANCE.initKeyPairIfNecessary$android_keystore_compat_release(KeystoreCompat.access$getUniqueId$p(INSTANCE));
                try {
                    String string = secret;
                    Charset charset = Charsets.UTF_8;
                    KeystoreCompatFacade keystoreCompatFacade = KeystoreCompatImpl.INSTANCE.getKeystoreCompat();
                    KeystoreCompat keystoreCompat = INSTANCE;
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    byte[] byArray2 = byArray;
                    KeyStore.Entry entry = KeystoreCompat.access$getKeyStore$p(INSTANCE).getEntry(KeystoreCompat.access$getUniqueId$p(INSTANCE), null);
                    if (entry == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.security.KeyStore.Entry");
                    }
                    keystoreCompat.setEncryptedSecret(keystoreCompatFacade.storeSecret(byArray2, entry, useBase64Encoding));
                    onSuccess.invoke();
                }
                catch (ForceLockScreenMarshmallowException fle) {
                    INSTANCE.clearCredentials();
                    onError.invoke((Object)fle);
                }
                catch (Exception e) {
                    INSTANCE.clearCredentials();
                    throw (Throwable)e;
                }
            } else {
                INSTANCE.clearCredentials();
                onError.invoke((Object)new EncryptionNotAllowedException(INSTANCE.isKeystoreCompatAvailable(), INSTANCE.isSecurityEnabled()));
            }
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void storeSecret$default(KeystoreCompat keystoreCompat, String string, Function1 function1, Function0 function0, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        keystoreCompat.storeSecret(string, (Function1<? super KeystoreCompatException, Unit>)function1, (Function0<Unit>)function0, bl);
    }

    @JvmOverloads
    public final void storeSecret(@NotNull String secret, @NotNull Function1<? super KeystoreCompatException, Unit> onError, @NotNull Function0<Unit> onSuccess) {
        KeystoreCompat.storeSecret$default(this, secret, onError, onSuccess, false, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasSecretLoadable() {
        if (Build.VERSION.SDK_INT < 19) return false;
        if (!this.isKeystoreCompatAvailable()) return false;
        if (!this.isSecurityEnabled()) return false;
        if (this.lockScreenCancelled$android_keystore_compat_release()) {
            return false;
        }
        String string = this.getEncryptedSecret();
        if (string == null) return false;
        CharSequence charSequence = string;
        if (StringsKt.isBlank((CharSequence)charSequence)) return false;
        boolean bl = true;
        if (!bl) return false;
        KeyStore keyStore = KeystoreCompat.keyStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keyStore");
        }
        String string2 = uniqueId;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uniqueId");
        }
        if (keyStore.getEntry(string2, null) == null) return false;
        return true;
    }

    @JvmOverloads
    public final void loadSecret(@NotNull Function1<? super byte[], Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure, @Nullable Boolean forceFlag, boolean isBase64Encoded) {
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onFailure, (String)"onFailure");
        if (Build.VERSION.SDK_INT >= 19) {
            KeyStore.Entry privateEntry = KeystoreCompat.access$getKeyStore$p(INSTANCE).getEntry(KeystoreCompat.access$getUniqueId$p(INSTANCE), null);
            if (privateEntry == null) {
                onFailure.invoke((Object)new RuntimeException("No entry in keystore available."));
            } else {
                KeystoreCompatFacade keystoreCompatFacade = KeystoreCompatImpl.INSTANCE.getKeystoreCompat();
                Function0 function0 = loadSecret.1.1.INSTANCE;
                String string = KeystoreCompat.INSTANCE.getEncryptedSecret();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.encryptedSecret");
                keystoreCompatFacade.loadSecret(onSuccess, onFailure, (Function0<Unit>)function0, forceFlag, string, privateEntry, isBase64Encoded);
            }
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void loadSecret$default(KeystoreCompat keystoreCompat, Function1 function1, Function1 function12, Boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        keystoreCompat.loadSecret((Function1<? super byte[], Unit>)function1, (Function1<? super Exception, Unit>)function12, bl, bl2);
    }

    @JvmOverloads
    public final void loadSecret(@NotNull Function1<? super byte[], Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure, @Nullable Boolean forceFlag) {
        KeystoreCompat.loadSecret$default(this, onSuccess, onFailure, forceFlag, false, 8, null);
    }

    @JvmOverloads
    public final void loadSecretAsString(@NotNull Function1<? super String, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure, @Nullable Boolean forceFlag, boolean isBase64Encoded) {
        Intrinsics.checkParameterIsNotNull(onSuccess, (String)"onSuccess");
        Intrinsics.checkParameterIsNotNull(onFailure, (String)"onFailure");
        if (Build.VERSION.SDK_INT >= 19) {
            KeyStore.Entry entry = KeystoreCompat.access$getKeyStore$p(INSTANCE).getEntry(KeystoreCompat.access$getUniqueId$p(INSTANCE), null);
            Intrinsics.checkExpressionValueIsNotNull((Object)entry, (String)"KeystoreCompat.keyStore.\u2026oreCompat.uniqueId, null)");
            KeyStore.Entry keyEntry = entry;
            KeystoreCompatFacade keystoreCompatFacade = KeystoreCompatImpl.INSTANCE.getKeystoreCompat();
            Function1 function1 = (Function1)new Function1<byte[], Unit>(onSuccess, onFailure, forceFlag, isBase64Encoded){
                final /* synthetic */ Function1 $onSuccess$inlined;
                final /* synthetic */ Function1 $onFailure$inlined;
                final /* synthetic */ Boolean $forceFlag$inlined;
                final /* synthetic */ boolean $isBase64Encoded$inlined;
                {
                    this.$onSuccess$inlined = function1;
                    this.$onFailure$inlined = function12;
                    this.$forceFlag$inlined = bl;
                    this.$isBase64Encoded$inlined = bl2;
                    super(1);
                }

                public final void invoke(@NotNull byte[] byteArray) {
                    Intrinsics.checkParameterIsNotNull((Object)byteArray, (String)"byteArray");
                    int n = 0;
                    int n2 = byteArray.length;
                    Charset charset = Charsets.UTF_8;
                    Function1 function1 = this.$onSuccess$inlined;
                    String string = new String(byteArray, n, n2, charset);
                    function1.invoke((Object)string);
                }
            };
            Function0 function0 = loadSecretAsString.1.2.INSTANCE;
            String string = KeystoreCompat.INSTANCE.getEncryptedSecret();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.encryptedSecret");
            keystoreCompatFacade.loadSecret((Function1<? super byte[], Unit>)function1, onFailure, (Function0<Unit>)function0, forceFlag, string, keyEntry, isBase64Encoded);
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void loadSecretAsString$default(KeystoreCompat keystoreCompat, Function1 function1, Function1 function12, Boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        keystoreCompat.loadSecretAsString((Function1<? super String, Unit>)function1, (Function1<? super Exception, Unit>)function12, bl, bl2);
    }

    @JvmOverloads
    public final void loadSecretAsString(@NotNull Function1<? super String, Unit> onSuccess, @NotNull Function1<? super Exception, Unit> onFailure, @Nullable Boolean forceFlag) {
        KeystoreCompat.loadSecretAsString$default(this, onSuccess, onFailure, forceFlag, false, 8, null);
    }

    public final void deactivate() {
        this.clearCredentials();
        KeystoreCompatFacade keystoreCompatFacade = KeystoreCompatImpl.INSTANCE.getKeystoreCompat();
        Context context = KeystoreCompat.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        }
        keystoreCompatFacade.deactivateRights(context);
    }

    public final void clearCredentials() {
        if (Build.VERSION.SDK_INT >= 19) {
            KeystoreCompat.INSTANCE.setEncryptedSecret("");
            try {
                KeystoreCompat.access$getKeyStore$p(INSTANCE).deleteEntry(KeystoreCompat.access$getUniqueId$p(INSTANCE));
            }
            catch (KeyStoreException ke) {
                Log.w((String)KeystoreCompat.access$getLOG_TAG$p(INSTANCE), (String)("Unable to delete entry:" + KeystoreCompat.access$getUniqueId$p(INSTANCE)), (Throwable)ke);
            }
        }
    }

    public final void increaseLockScreenCancel() {
        if (Build.VERSION.SDK_INT >= 19) {
            KeystoreCompat keystoreCompat = INSTANCE;
            int n = keystoreCompat.getLockScreenCancelCount();
            keystoreCompat.setLockScreenCancelCount(n + 1);
        }
    }

    public final void lockScreenSuccessful() {
        if (Build.VERSION.SDK_INT >= 19) {
            KeystoreCompat.INSTANCE.setLockScreenCancelCount(0);
        }
    }

    public final boolean lockScreenCancelled$android_keystore_compat_release() {
        int n = this.getLockScreenCancelCount();
        KeystoreCompatConfig keystoreCompatConfig = config;
        if (keystoreCompatConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        }
        return n >= keystoreCompatConfig.getDialogDismissThreshold();
    }

    public final void init$android_keystore_compat_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 19) {
            INSTANCE.setContext(context);
            INSTANCE.setConfig(new KeystoreCompatConfig());
            String string = Settings.Secure.getString((ContentResolver)INSTANCE.getContext().getContentResolver(), (String)"android_id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Settings.Secure.getStrin\u2026ttings.Secure.ANDROID_ID)");
            KeystoreCompat.access$setUniqueId$p(INSTANCE, string);
            Log.d((String)KeystoreCompat.access$getLOG_TAG$p(INSTANCE), (String)("uniqueId:" + KeystoreCompat.access$getUniqueId$p(INSTANCE)));
            PrefDelegate.Companion.initialize(INSTANCE.getContext());
            KeystoreCompat.access$setCertSubject$p(INSTANCE, new X500Principal("CN=" + KeystoreCompat.access$getUniqueId$p(INSTANCE) + ", O=Android Authority"));
            KeyStore keyStore = KeyStore.getInstance(INSTANCE.getKEYSTORE_KEYWORD());
            Intrinsics.checkExpressionValueIsNotNull((Object)keyStore, (String)"KeyStore.getInstance(KEYSTORE_KEYWORD)");
            KeystoreCompat.access$setKeyStore$p(INSTANCE, keyStore);
            KeystoreCompat.access$getKeyStore$p(INSTANCE).load(null);
            KeystoreCompatImpl.INSTANCE.init(Build.VERSION.SDK_INT);
        }
    }

    public final void initKeyPairIfNecessary$android_keystore_compat_release(@NotNull String alias) {
        Intrinsics.checkParameterIsNotNull((Object)alias, (String)"alias");
        if (this.isKeystoreCompatAvailable() && this.isSecurityEnabled()) {
            KeyStore keyStore = KeystoreCompat.keyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"keyStore");
            }
            if (keyStore.containsAlias(alias) && this.isCertificateValid()) {
                return;
            }
            this.createNewKeyPair(alias);
        }
    }

    private final void logUnsupportedVersionForKeystore() {
        Log.w((String)LOG_TAG, (String)("Device Android version[" + Build.VERSION.SDK_INT + "] doesn't offer trusted keystore functionality!"));
    }

    private final boolean isCertificateValid() {
        return true;
    }

    private final void createNewKeyPair(String aliasText) {
        try {
            Calendar start = Calendar.getInstance();
            start.add(12, -1);
            Calendar end = Calendar.getInstance();
            end.add(1, 1);
            KeystoreCompatFacade keystoreCompatFacade = KeystoreCompatImpl.INSTANCE.getKeystoreCompat();
            Date date = start.getTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"start.time");
            Date date2 = end.getTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"end.time");
            X500Principal x500Principal = certSubject;
            if (x500Principal == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"certSubject");
            }
            Context context = KeystoreCompat.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            }
            keystoreCompatFacade.generateKeyPair(aliasText, date, date2, x500Principal, context);
            KeyStore keyStore = KeystoreCompat.keyStore;
            if (keyStore == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"keyStore");
            }
            if (!keyStore.containsAlias(aliasText)) {
                throw (Throwable)new RuntimeException("KeyPair was NOT stored!");
            }
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Unable to create keys!", (Throwable)e);
            throw (Throwable)e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isDeviceRooted(Context context) {
        block8: {
            ret = new RootBeer(context).isRooted();
            if (KeystoreCompat.isRooted != null) break block8;
            if (ret) {
                check = new RootBeer(context);
                v0 = new StringBuilder().append("RootDetection enabled ");
                v1 = KeystoreCompat.config;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                }
                Log.w((String)KeystoreCompat.LOG_TAG, (String)v0.append(v1.isRootDetectionEnabled()).toString());
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("Root Management Apps " + (check.detectRootManagementApps() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("PotentiallyDangerousApps " + (check.detectPotentiallyDangerousApps() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("TestKeys " + (check.detectTestKeys() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("BusyBoxBinary " + (check.checkForBusyBoxBinary() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("SU Binary " + (check.checkForSuBinary() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("2nd SU Binary check " + (check.checkSuExists() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("ForRWPaths " + (check.checkForRWPaths() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("DangerousProps " + (check.checkForDangerousProps() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("Root via native check " + (check.checkForRootNative() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("RootCloakingApps " + (check.detectRootCloakingApps() != false ? "detected" : "not detected")));
                Log.w((String)KeystoreCompat.LOG_TAG, (String)("Selinux Flag Is Enabled " + (Utils.isSelinuxFlagInEnabled() != false ? "true" : "false")));
            }
            if (!ret) ** GOTO lbl-1000
            v2 = KeystoreCompat.config;
            if (v2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            }
            if (v2.isRootDetectionEnabled()) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            KeystoreCompat.isRooted = v3;
        }
        v4 = KeystoreCompat.isRooted;
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        if (v4.booleanValue()) {
            this.clearCredentials();
        }
        v5 = KeystoreCompat.isRooted;
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        return v5;
    }

    private KeystoreCompat() {
        INSTANCE = this;
        KEYSTORE_KEYWORD = KEYSTORE_KEYWORD;
        LOG_TAG = this.getClass().getName();
        encryptedSecret$delegate = PrefDelegateKt.stringPref$default("secure_string", null, 2, null);
        lockScreenCancelCount$delegate = PrefDelegateKt.intPref$default("sign_up_cancel_count", 0, 2, null);
    }

    public static final /* synthetic */ String access$getLOG_TAG$p(KeystoreCompat $this) {
        KeystoreCompat keystoreCompat = $this;
        return LOG_TAG;
    }

    @NotNull
    public static final /* synthetic */ String access$getUniqueId$p(KeystoreCompat $this) {
        KeystoreCompat keystoreCompat = $this;
        String string = uniqueId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uniqueId");
        }
        return string;
    }

    public static final /* synthetic */ void access$setUniqueId$p(KeystoreCompat $this, @NotNull String string) {
        KeystoreCompat keystoreCompat = $this;
        uniqueId = string;
    }

    @NotNull
    public static final /* synthetic */ KeyStore access$getKeyStore$p(KeystoreCompat $this) {
        KeystoreCompat keystoreCompat = $this;
        KeyStore keyStore = KeystoreCompat.keyStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keyStore");
        }
        return keyStore;
    }

    public static final /* synthetic */ void access$setKeyStore$p(KeystoreCompat $this, @NotNull KeyStore keyStore) {
        KeystoreCompat keystoreCompat = $this;
        KeystoreCompat.keyStore = keyStore;
    }

    @NotNull
    public static final /* synthetic */ X500Principal access$getCertSubject$p(KeystoreCompat $this) {
        KeystoreCompat keystoreCompat = $this;
        X500Principal x500Principal = certSubject;
        if (x500Principal == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"certSubject");
        }
        return x500Principal;
    }

    public static final /* synthetic */ void access$setCertSubject$p(KeystoreCompat $this, @NotNull X500Principal x500Principal) {
        KeystoreCompat keystoreCompat = $this;
        certSubject = x500Principal;
    }
}

