/*
 * Decompiled with CFR 0.152.
 */
package cz.kinst.jakub.view;

import android.databinding.BindingAdapter;
import android.view.View;
import cz.kinst.jakub.view.StatefulLayout;
import java.util.HashMap;
import java.util.Map;

public class StateController {
    private Map<String, View> mStateMap = new HashMap<String, View>();
    private String mState = "content";
    private StatefulLayout.OnStateChangeListener mListener;

    private StateController() {
    }

    @BindingAdapter(value={"stateController"})
    public static void setStateController(StatefulLayout statefulLayout, StateController stateController) {
        statefulLayout.setStateController(stateController);
    }

    public static Builder create() {
        return new Builder();
    }

    public Map<String, View> getStates() {
        return this.mStateMap;
    }

    public String getState() {
        return this.mState;
    }

    public void setState(String newState) {
        this.mState = newState;
        if (this.mListener != null) {
            this.mListener.onStateChange(newState);
        }
    }

    void setOnStateChangeListener(StatefulLayout.OnStateChangeListener listener) {
        this.mListener = listener;
    }

    public static class Builder {
        StateController mStateController = new StateController();

        public Builder withState(String state, View stateView) {
            this.mStateController.mStateMap.put(state, stateView);
            return this;
        }

        public StateController build() {
            return this.mStateController;
        }
    }
}

