/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import com.googlecode.leptonica.android.Pix;

public class Skew {
    public static final float SWEEP_RANGE = 30.0f;
    public static final float SWEEP_DELTA = 5.0f;
    public static final int SWEEP_REDUCTION = 8;
    public static final int SEARCH_REDUCTION = 4;
    public static final float SEARCH_MIN_DELTA = 0.01f;

    public static float findSkew(Pix pixs) {
        return Skew.findSkew(pixs, 30.0f, 5.0f, 8, 4, 0.01f);
    }

    public static float findSkew(Pix pixs, float sweepRange, float sweepDelta, int sweepReduction, int searchReduction, float searchMinDelta) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        return Skew.nativeFindSkew(pixs.getNativePix(), sweepRange, sweepDelta, sweepReduction, searchReduction, searchMinDelta);
    }

    public static Pix deskew(Pix pixs, float[] result) {
        return Skew.deskew(pixs, 0, 30.0f, 5.0f, 0, 0, result);
    }

    public static Pix deskew(Pix pixs, int sweepReduction, float sweepRange, float sweepDelta, int searchReduction, int threshold, float[] result) {
        if (pixs == null) {
            throw new IllegalArgumentException("Source pix must be non-null");
        }
        long nativePix = Skew.nativeDeskew(pixs.getNativePix(), sweepReduction, sweepRange, sweepDelta, searchReduction, threshold, result);
        if (nativePix == 0L) {
            throw new RuntimeException("Failed to deskew pix");
        }
        return new Pix(nativePix);
    }

    private static native float nativeFindSkew(long var0, float var2, float var3, int var4, int var5, float var6);

    private static native long nativeDeskew(long var0, int var2, float var3, float var4, int var5, int var6, float[] var7);

    static {
        System.loadLibrary("jpeg");
        System.loadLibrary("pngx");
        System.loadLibrary("leptonica");
    }
}

