/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.tesseract.android;

import android.util.Log;
import android.util.Pair;
import com.googlecode.tesseract.android.PageIterator;
import java.util.ArrayList;
import java.util.List;

public class ResultIterator
extends PageIterator {
    private final long mNativeResultIterator;

    ResultIterator(long nativeResultIterator) {
        super(nativeResultIterator);
        this.mNativeResultIterator = nativeResultIterator;
    }

    public String getUTF8Text(int level) {
        return ResultIterator.nativeGetUTF8Text(this.mNativeResultIterator, level);
    }

    public float confidence(int level) {
        return ResultIterator.nativeConfidence(this.mNativeResultIterator, level);
    }

    public boolean isAtBeginningOf(int level) {
        return ResultIterator.nativeIsAtBeginningOf(this.mNativeResultIterator, level);
    }

    public boolean isAtFinalElement(int level, int element) {
        return ResultIterator.nativeIsAtFinalElement(this.mNativeResultIterator, level, element);
    }

    public List<Pair<String, Double>> getSymbolChoicesAndConfidence() {
        String[] nativeChoices = ResultIterator.nativeGetSymbolChoices(this.mNativeResultIterator);
        ArrayList<Pair<String, Double>> pairedResults = new ArrayList<Pair<String, Double>>();
        for (String nativeChoice : nativeChoices) {
            String utfString;
            int separatorPosition = nativeChoice.lastIndexOf(124);
            Double confidenceLevel = 0.0;
            if (separatorPosition > 0) {
                utfString = nativeChoice.substring(0, separatorPosition);
                try {
                    confidenceLevel = Double.parseDouble(nativeChoice.substring(separatorPosition + 1));
                }
                catch (NumberFormatException e) {
                    Log.e((String)"ResultIterator", (String)("Invalid confidence level for " + nativeChoice));
                }
            } else {
                utfString = nativeChoice;
            }
            pairedResults.add((Pair<String, Double>)new Pair((Object)utfString, (Object)confidenceLevel));
        }
        return pairedResults;
    }

    public void delete() {
        ResultIterator.nativeDelete(this.mNativeResultIterator);
    }

    private static native String[] nativeGetSymbolChoices(long var0);

    private static native String nativeGetUTF8Text(long var0, int var2);

    private static native float nativeConfidence(long var0, int var2);

    private static native boolean nativeIsAtBeginningOf(long var0, int var2);

    private static native boolean nativeIsAtFinalElement(long var0, int var2, int var3);

    private static native void nativeDelete(long var0);

    static {
        System.loadLibrary("jpeg");
        System.loadLibrary("pngx");
        System.loadLibrary("leptonica");
        System.loadLibrary("tesseract");
    }
}

