/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.leptonica.android;

import android.graphics.Rect;
import androidx.annotation.Size;

public class Box {
    private static final String TAG;
    public static final int INDEX_X = 0;
    public static final int INDEX_Y = 1;
    public static final int INDEX_W = 2;
    public static final int INDEX_H = 3;
    private final long mNativeBox;
    private boolean mRecycled = false;

    Box(long nativeBox) {
        this.mNativeBox = nativeBox;
        this.mRecycled = false;
    }

    public Box(int x, int y, int w, int h) {
        if (x < 0 || y < 0 || w < 0 || h < 0) {
            throw new IllegalArgumentException("All box dimensions must be non-negative");
        }
        long nativeBox = Box.nativeCreate(x, y, w, h);
        if (nativeBox == 0L) {
            throw new OutOfMemoryError();
        }
        this.mNativeBox = nativeBox;
        this.mRecycled = false;
    }

    public long getNativeBox() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.mNativeBox;
    }

    public int getX() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Box.nativeGetX(this.mNativeBox);
    }

    public int getY() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Box.nativeGetY(this.mNativeBox);
    }

    public int getWidth() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Box.nativeGetWidth(this.mNativeBox);
    }

    public int getHeight() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Box.nativeGetHeight(this.mNativeBox);
    }

    public Rect getRect() {
        int[] geometry = this.getGeometry();
        int left = geometry[0];
        int top = geometry[1];
        int right = left + geometry[2];
        int bottom = top + geometry[3];
        return new Rect(left, top, right, bottom);
    }

    public int[] getGeometry() {
        int[] geometry = new int[4];
        if (this.getGeometry(geometry)) {
            return geometry;
        }
        return null;
    }

    public boolean getGeometry(@Size(min=4L) int[] geometry) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        if (geometry.length < 4) {
            throw new IllegalArgumentException("Geometry array must be at least 4 elements long");
        }
        return Box.nativeGetGeometry(this.mNativeBox, geometry);
    }

    public int getRefCount() {
        return Box.nativeGetRefCount(this.mNativeBox);
    }

    public void recycle() {
        if (!this.mRecycled) {
            Box.nativeDestroy(this.mNativeBox);
            this.mRecycled = true;
        }
    }

    private static native long nativeCreate(int var0, int var1, int var2, int var3);

    private static native int nativeGetX(long var0);

    private static native int nativeGetY(long var0);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native int nativeGetRefCount(long var0);

    private static native void nativeDestroy(long var0);

    private static native boolean nativeGetGeometry(long var0, int[] var2);

    static {
        System.loadLibrary("jpeg");
        System.loadLibrary("png");
        System.loadLibrary("leptonica");
        TAG = Box.class.getSimpleName();
    }
}

