/*
 * Decompiled with CFR 0.152.
 */
package cz.ackee.retrofitadapter.chain;

import cz.ackee.retrofitadapter.chain.CallChain;
import cz.ackee.retrofitadapter.interceptor.CallFactoryInterceptor;
import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u001c\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcz/ackee/retrofitadapter/chain/CallChainImpl;", "Lcz/ackee/retrofitadapter/chain/CallChain;", "chainIndex", "", "actualCall", "Lretrofit2/Call;", "annotationArray", "", "", "interceptors", "", "Lcz/ackee/retrofitadapter/interceptor/CallFactoryInterceptor;", "(ILretrofit2/Call;[Ljava/lang/annotation/Annotation;Ljava/util/List;)V", "[Ljava/lang/annotation/Annotation;", "annotations", "getAnnotations", "()[Ljava/lang/annotation/Annotation;", "call", "getCall", "()Lretrofit2/Call;", "proceed", "coroutine-adapter_release"})
public final class CallChainImpl
implements CallChain {
    private final int chainIndex;
    private final Call<?> actualCall;
    private final Annotation[] annotationArray;
    private final List<CallFactoryInterceptor> interceptors;

    @Override
    @NotNull
    public Call<?> getCall() {
        return this.actualCall;
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this.annotationArray;
    }

    @Override
    @NotNull
    public Call<?> proceed(@NotNull Call<?> call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        boolean bl = this.chainIndex <= CollectionsKt.getLastIndex(this.interceptors);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "chainIndex " + (this.chainIndex + 1) + " does not match with actual interceptor size " + this.interceptors.size();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        CallChainImpl newChain = new CallChainImpl(this.chainIndex + 1, call, this.getAnnotations(), this.interceptors);
        return this.interceptors.get(this.chainIndex).intercept(newChain);
    }

    public CallChainImpl(int chainIndex, @NotNull Call<?> actualCall, @NotNull Annotation[] annotationArray, @NotNull List<? extends CallFactoryInterceptor> interceptors) {
        Intrinsics.checkNotNullParameter(actualCall, (String)"actualCall");
        Intrinsics.checkNotNullParameter((Object)annotationArray, (String)"annotationArray");
        Intrinsics.checkNotNullParameter(interceptors, (String)"interceptors");
        this.chainIndex = chainIndex;
        this.actualCall = actualCall;
        this.annotationArray = annotationArray;
        this.interceptors = interceptors;
    }
}

