/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.ItemTier;
import org.openapitools.client.model.Overage;
import org.openapitools.client.model.Recurring;
import org.openapitools.client.model.SubscriptionItemDrawdownField;
import org.openapitools.client.model.SubscriptionItemPrepaymentField;
import org.threeten.bp.LocalDate;

public class SubscriptionItemCreateRequest {
    public static final String SERIALIZED_NAME_PRICE_ID = "price_id";
    @SerializedName(value="price_id")
    private String priceId;
    public static final String SERIALIZED_NAME_SUBSCRIPTION_ITEM_NUMBER = "subscription_item_number";
    @SerializedName(value="subscription_item_number")
    private String subscriptionItemNumber;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_RECURRING = "recurring";
    @SerializedName(value="recurring")
    private Recurring recurring;
    public static final String SERIALIZED_NAME_START_EVENT = "start_event";
    @SerializedName(value="start_event")
    private StartEventEnum startEvent;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_TIERS_MODE = "tiers_mode";
    @SerializedName(value="tiers_mode")
    private TiersModeEnum tiersMode;
    public static final String SERIALIZED_NAME_TIERS = "tiers";
    @SerializedName(value="tiers")
    private List<ItemTier> tiers = null;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private BigDecimal quantity;
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private BigDecimal amount;
    public static final String SERIALIZED_NAME_UNIT_AMOUNT = "unit_amount";
    @SerializedName(value="unit_amount")
    private BigDecimal unitAmount;
    public static final String SERIALIZED_NAME_DISCOUNT_AMOUNT = "discount_amount";
    @SerializedName(value="discount_amount")
    private BigDecimal discountAmount;
    public static final String SERIALIZED_NAME_DISCOUNT_PERCENT = "discount_percent";
    @SerializedName(value="discount_percent")
    private BigDecimal discountPercent;
    public static final String SERIALIZED_NAME_PRICE_BASE_INTERVAL = "price_base_interval";
    @SerializedName(value="price_base_interval")
    private PriceBaseIntervalEnum priceBaseInterval;
    public static final String SERIALIZED_NAME_OVERAGE = "overage";
    @SerializedName(value="overage")
    private Overage overage;
    public static final String SERIALIZED_NAME_UNIQUE_TOKEN = "unique_token";
    @SerializedName(value="unique_token")
    private String uniqueToken;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;
    public static final String SERIALIZED_NAME_APPLY_DISCOUNT_TO = "apply_discount_to";
    @SerializedName(value="apply_discount_to")
    private List<ApplyDiscountToEnum> applyDiscountTo = null;
    public static final String SERIALIZED_NAME_DISCOUNT_LEVEL = "discount_level";
    @SerializedName(value="discount_level")
    private DiscountLevelEnum discountLevel;
    public static final String SERIALIZED_NAME_CUSTOM_FIELD_PER_UNIT_RATE = "custom_field_per_unit_rate";
    @SerializedName(value="custom_field_per_unit_rate")
    private String customFieldPerUnitRate;
    public static final String SERIALIZED_NAME_CUSTOM_FIELD_TOTAL_AMOUNT = "custom_field_total_amount";
    @SerializedName(value="custom_field_total_amount")
    private String customFieldTotalAmount;
    public static final String SERIALIZED_NAME_PRICE_CHANGE_PERCENTAGE = "price_change_percentage";
    @SerializedName(value="price_change_percentage")
    private BigDecimal priceChangePercentage;
    public static final String SERIALIZED_NAME_PRICE_CHANGE_OPTION = "price_change_option";
    @SerializedName(value="price_change_option")
    private PriceChangeOptionEnum priceChangeOption;
    public static final String SERIALIZED_NAME_PREPAYMENT = "prepayment";
    @SerializedName(value="prepayment")
    private SubscriptionItemPrepaymentField prepayment;
    public static final String SERIALIZED_NAME_DRAWDOWN = "drawdown";
    @SerializedName(value="drawdown")
    private SubscriptionItemDrawdownField drawdown;

    public SubscriptionItemCreateRequest priceId(String priceId) {
        this.priceId = priceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Identifier of the price.")
    public String getPriceId() {
        return this.priceId;
    }

    public void setPriceId(String priceId) {
        this.priceId = priceId;
    }

    public SubscriptionItemCreateRequest subscriptionItemNumber(String subscriptionItemNumber) {
        this.subscriptionItemNumber = subscriptionItemNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable identifier of the subscription item. It can be user-supplied.")
    public String getSubscriptionItemNumber() {
        return this.subscriptionItemNumber;
    }

    public void setSubscriptionItemNumber(String subscriptionItemNumber) {
        this.subscriptionItemNumber = subscriptionItemNumber;
    }

    public SubscriptionItemCreateRequest description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the price. Often useful for displaying to users.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SubscriptionItemCreateRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Recurring getRecurring() {
        return this.recurring;
    }

    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
    }

    public SubscriptionItemCreateRequest startEvent(StartEventEnum startEvent) {
        this.startEvent = startEvent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies when to start billing your customer.")
    public StartEventEnum getStartEvent() {
        return this.startEvent;
    }

    public void setStartEvent(StartEventEnum startEvent) {
        this.startEvent = startEvent;
    }

    public SubscriptionItemCreateRequest startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when the subscription item starts")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public SubscriptionItemCreateRequest endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date when the subscription item ends or ended.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public SubscriptionItemCreateRequest tiersMode(TiersModeEnum tiersMode) {
        this.tiersMode = tiersMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the mode of tiering.")
    public TiersModeEnum getTiersMode() {
        return this.tiersMode;
    }

    public void setTiersMode(TiersModeEnum tiersMode) {
        this.tiersMode = tiersMode;
    }

    public SubscriptionItemCreateRequest tiers(List<ItemTier> tiers) {
        this.tiers = tiers;
        return this;
    }

    public SubscriptionItemCreateRequest addTiersItem(ItemTier tiersItem) {
        if (this.tiers == null) {
            this.tiers = new ArrayList<ItemTier>();
        }
        this.tiers.add(tiersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Information of all tiers if the price is a tiered price.")
    public List<ItemTier> getTiers() {
        return this.tiers;
    }

    public void setTiers(List<ItemTier> tiers) {
        this.tiers = tiers;
    }

    public SubscriptionItemCreateRequest quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity of the product to which your customers subscribe.")
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public SubscriptionItemCreateRequest amount(BigDecimal amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount of the price. Specify this field if you want to override the original price with a flat-fee price")
    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public SubscriptionItemCreateRequest unitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unit amount of the price. Specify this field if you want to override the original price with a per-unit price.")
    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public void setUnitAmount(BigDecimal unitAmount) {
        this.unitAmount = unitAmount;
    }

    public SubscriptionItemCreateRequest discountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount amount. Specify this field if you offer an amount-based discount.")
    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public SubscriptionItemCreateRequest discountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Discount percent. Specify this field if you offer a percentage-based discount.")
    public BigDecimal getDiscountPercent() {
        return this.discountPercent;
    }

    public void setDiscountPercent(BigDecimal discountPercent) {
        this.discountPercent = discountPercent;
    }

    public SubscriptionItemCreateRequest priceBaseInterval(PriceBaseIntervalEnum priceBaseInterval) {
        this.priceBaseInterval = priceBaseInterval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the base interval of the price the subscriber is subscribed to. If not provided, this field defaults to `billing_period`.")
    public PriceBaseIntervalEnum getPriceBaseInterval() {
        return this.priceBaseInterval;
    }

    public void setPriceBaseInterval(PriceBaseIntervalEnum priceBaseInterval) {
        this.priceBaseInterval = priceBaseInterval;
    }

    public SubscriptionItemCreateRequest overage(Overage overage) {
        this.overage = overage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Overage getOverage() {
        return this.overage;
    }

    public void setOverage(Overage overage) {
        this.overage = overage;
    }

    public SubscriptionItemCreateRequest uniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the price. This identifier enables you to refer to the price before the price has an internal identifier in Zuora.")
    public String getUniqueToken() {
        return this.uniqueToken;
    }

    public void setUniqueToken(String uniqueToken) {
        this.uniqueToken = uniqueToken;
    }

    public SubscriptionItemCreateRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionItemCreateRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public SubscriptionItemCreateRequest applyDiscountTo(List<ApplyDiscountToEnum> applyDiscountTo) {
        this.applyDiscountTo = applyDiscountTo;
        return this;
    }

    public SubscriptionItemCreateRequest addApplyDiscountToItem(ApplyDiscountToEnum applyDiscountToItem) {
        if (this.applyDiscountTo == null) {
            this.applyDiscountTo = new ArrayList<ApplyDiscountToEnum>();
        }
        this.applyDiscountTo.add(applyDiscountToItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Any combination of one-time, recurring, and usage.")
    public List<ApplyDiscountToEnum> getApplyDiscountTo() {
        return this.applyDiscountTo;
    }

    public void setApplyDiscountTo(List<ApplyDiscountToEnum> applyDiscountTo) {
        this.applyDiscountTo = applyDiscountTo;
    }

    public SubscriptionItemCreateRequest discountLevel(DiscountLevelEnum discountLevel) {
        this.discountLevel = discountLevel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies at what level a discount should be applied: one of account, subscription or plan.")
    public DiscountLevelEnum getDiscountLevel() {
        return this.discountLevel;
    }

    public void setDiscountLevel(DiscountLevelEnum discountLevel) {
        this.discountLevel = discountLevel;
    }

    public SubscriptionItemCreateRequest customFieldPerUnitRate(String customFieldPerUnitRate) {
        this.customFieldPerUnitRate = customFieldPerUnitRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the custom field that will be used to set a per unit rate under the `Pre-Rated Per Unit` charge model ")
    public String getCustomFieldPerUnitRate() {
        return this.customFieldPerUnitRate;
    }

    public void setCustomFieldPerUnitRate(String customFieldPerUnitRate) {
        this.customFieldPerUnitRate = customFieldPerUnitRate;
    }

    public SubscriptionItemCreateRequest customFieldTotalAmount(String customFieldTotalAmount) {
        this.customFieldTotalAmount = customFieldTotalAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name of the custom field that will be used to set a total amount under the `Pre-Rated` charge model ")
    public String getCustomFieldTotalAmount() {
        return this.customFieldTotalAmount;
    }

    public void setCustomFieldTotalAmount(String customFieldTotalAmount) {
        this.customFieldTotalAmount = customFieldTotalAmount;
    }

    public SubscriptionItemCreateRequest priceChangePercentage(BigDecimal priceChangePercentage) {
        this.priceChangePercentage = priceChangePercentage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage to increase or decrease the price of a termed subscription's renewal.")
    public BigDecimal getPriceChangePercentage() {
        return this.priceChangePercentage;
    }

    public void setPriceChangePercentage(BigDecimal priceChangePercentage) {
        this.priceChangePercentage = priceChangePercentage;
    }

    public SubscriptionItemCreateRequest priceChangeOption(PriceChangeOptionEnum priceChangeOption) {
        this.priceChangeOption = priceChangeOption;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Applies an automatic price change when a termed subscription is renewed.")
    public PriceChangeOptionEnum getPriceChangeOption() {
        return this.priceChangeOption;
    }

    public void setPriceChangeOption(PriceChangeOptionEnum priceChangeOption) {
        this.priceChangeOption = priceChangeOption;
    }

    public SubscriptionItemCreateRequest prepayment(SubscriptionItemPrepaymentField prepayment) {
        this.prepayment = prepayment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionItemPrepaymentField getPrepayment() {
        return this.prepayment;
    }

    public void setPrepayment(SubscriptionItemPrepaymentField prepayment) {
        this.prepayment = prepayment;
    }

    public SubscriptionItemCreateRequest drawdown(SubscriptionItemDrawdownField drawdown) {
        this.drawdown = drawdown;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public SubscriptionItemDrawdownField getDrawdown() {
        return this.drawdown;
    }

    public void setDrawdown(SubscriptionItemDrawdownField drawdown) {
        this.drawdown = drawdown;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionItemCreateRequest subscriptionItemCreateRequest = (SubscriptionItemCreateRequest)o;
        return Objects.equals(this.priceId, subscriptionItemCreateRequest.priceId) && Objects.equals(this.subscriptionItemNumber, subscriptionItemCreateRequest.subscriptionItemNumber) && Objects.equals(this.description, subscriptionItemCreateRequest.description) && Objects.equals(this.recurring, subscriptionItemCreateRequest.recurring) && Objects.equals((Object)this.startEvent, (Object)subscriptionItemCreateRequest.startEvent) && Objects.equals(this.startDate, subscriptionItemCreateRequest.startDate) && Objects.equals(this.endDate, subscriptionItemCreateRequest.endDate) && Objects.equals((Object)this.tiersMode, (Object)subscriptionItemCreateRequest.tiersMode) && Objects.equals(this.tiers, subscriptionItemCreateRequest.tiers) && Objects.equals(this.quantity, subscriptionItemCreateRequest.quantity) && Objects.equals(this.amount, subscriptionItemCreateRequest.amount) && Objects.equals(this.unitAmount, subscriptionItemCreateRequest.unitAmount) && Objects.equals(this.discountAmount, subscriptionItemCreateRequest.discountAmount) && Objects.equals(this.discountPercent, subscriptionItemCreateRequest.discountPercent) && Objects.equals((Object)this.priceBaseInterval, (Object)subscriptionItemCreateRequest.priceBaseInterval) && Objects.equals(this.overage, subscriptionItemCreateRequest.overage) && Objects.equals(this.uniqueToken, subscriptionItemCreateRequest.uniqueToken) && Objects.equals(this.customFields, subscriptionItemCreateRequest.customFields) && Objects.equals(this.applyDiscountTo, subscriptionItemCreateRequest.applyDiscountTo) && Objects.equals((Object)this.discountLevel, (Object)subscriptionItemCreateRequest.discountLevel) && Objects.equals(this.customFieldPerUnitRate, subscriptionItemCreateRequest.customFieldPerUnitRate) && Objects.equals(this.customFieldTotalAmount, subscriptionItemCreateRequest.customFieldTotalAmount) && Objects.equals(this.priceChangePercentage, subscriptionItemCreateRequest.priceChangePercentage) && Objects.equals((Object)this.priceChangeOption, (Object)subscriptionItemCreateRequest.priceChangeOption) && Objects.equals(this.prepayment, subscriptionItemCreateRequest.prepayment) && Objects.equals(this.drawdown, subscriptionItemCreateRequest.drawdown);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.priceId, this.subscriptionItemNumber, this.description, this.recurring, this.startEvent, this.startDate, this.endDate, this.tiersMode, this.tiers, this.quantity, this.amount, this.unitAmount, this.discountAmount, this.discountPercent, this.priceBaseInterval, this.overage, this.uniqueToken, this.customFields, this.applyDiscountTo, this.discountLevel, this.customFieldPerUnitRate, this.customFieldTotalAmount, this.priceChangePercentage, this.priceChangeOption, this.prepayment, this.drawdown});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionItemCreateRequest {\n");
        sb.append("    priceId: ").append(this.toIndentedString(this.priceId)).append("\n");
        sb.append("    subscriptionItemNumber: ").append(this.toIndentedString(this.subscriptionItemNumber)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    startEvent: ").append(this.toIndentedString((Object)this.startEvent)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    tiersMode: ").append(this.toIndentedString((Object)this.tiersMode)).append("\n");
        sb.append("    tiers: ").append(this.toIndentedString(this.tiers)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    unitAmount: ").append(this.toIndentedString(this.unitAmount)).append("\n");
        sb.append("    discountAmount: ").append(this.toIndentedString(this.discountAmount)).append("\n");
        sb.append("    discountPercent: ").append(this.toIndentedString(this.discountPercent)).append("\n");
        sb.append("    priceBaseInterval: ").append(this.toIndentedString((Object)this.priceBaseInterval)).append("\n");
        sb.append("    overage: ").append(this.toIndentedString(this.overage)).append("\n");
        sb.append("    uniqueToken: ").append(this.toIndentedString(this.uniqueToken)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("    applyDiscountTo: ").append(this.toIndentedString(this.applyDiscountTo)).append("\n");
        sb.append("    discountLevel: ").append(this.toIndentedString((Object)this.discountLevel)).append("\n");
        sb.append("    customFieldPerUnitRate: ").append(this.toIndentedString(this.customFieldPerUnitRate)).append("\n");
        sb.append("    customFieldTotalAmount: ").append(this.toIndentedString(this.customFieldTotalAmount)).append("\n");
        sb.append("    priceChangePercentage: ").append(this.toIndentedString(this.priceChangePercentage)).append("\n");
        sb.append("    priceChangeOption: ").append(this.toIndentedString((Object)this.priceChangeOption)).append("\n");
        sb.append("    prepayment: ").append(this.toIndentedString(this.prepayment)).append("\n");
        sb.append("    drawdown: ").append(this.toIndentedString(this.drawdown)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PriceChangeOptionEnum {
        LATEST_CATALOG_PRICING("latest_catalog_pricing"),
        PERCENTAGE("percentage"),
        NONE("none"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PriceChangeOptionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PriceChangeOptionEnum fromValue(String value) {
            for (PriceChangeOptionEnum b : PriceChangeOptionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PriceChangeOptionEnum> {
            public void write(JsonWriter jsonWriter, PriceChangeOptionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PriceChangeOptionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PriceChangeOptionEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DiscountLevelEnum {
        ACCOUNT("account"),
        SUBSCRIPTION("subscription"),
        PLAN("plan"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private DiscountLevelEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DiscountLevelEnum fromValue(String value) {
            for (DiscountLevelEnum b : DiscountLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<DiscountLevelEnum> {
            public void write(JsonWriter jsonWriter, DiscountLevelEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DiscountLevelEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DiscountLevelEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ApplyDiscountToEnum {
        ONE_TIME("one_time"),
        RECURRING("recurring"),
        USAGE("usage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ApplyDiscountToEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ApplyDiscountToEnum fromValue(String value) {
            for (ApplyDiscountToEnum b : ApplyDiscountToEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ApplyDiscountToEnum> {
            public void write(JsonWriter jsonWriter, ApplyDiscountToEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ApplyDiscountToEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ApplyDiscountToEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PriceBaseIntervalEnum {
        MONTH("month"),
        BILLING_PERIOD("billing_period"),
        WEEK("week"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private PriceBaseIntervalEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PriceBaseIntervalEnum fromValue(String value) {
            for (PriceBaseIntervalEnum b : PriceBaseIntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PriceBaseIntervalEnum> {
            public void write(JsonWriter jsonWriter, PriceBaseIntervalEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PriceBaseIntervalEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PriceBaseIntervalEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TiersModeEnum {
        GRADUATED("graduated"),
        VOLUME("volume"),
        HIGH_WATERMARK_VOLUME("high_watermark_volume"),
        HIGH_WATERMARK_GRADUATED("high_watermark_graduated"),
        GRADUATED_WITH_OVERAGE("graduated_with_overage"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TiersModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TiersModeEnum fromValue(String value) {
            for (TiersModeEnum b : TiersModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TiersModeEnum> {
            public void write(JsonWriter jsonWriter, TiersModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TiersModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TiersModeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StartEventEnum {
        CONTRACT_EFFECTIVE("contract_effective"),
        SERVICE_ACTIVATION("service_activation"),
        CUSTOMER_ACCEPTANCE("customer_acceptance"),
        SPECIFIC_DATE("specific_date"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StartEventEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StartEventEnum fromValue(String value) {
            for (StartEventEnum b : StartEventEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StartEventEnum> {
            public void write(JsonWriter jsonWriter, StartEventEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StartEventEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StartEventEnum.fromValue(value);
            }
        }
    }
}

