/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;

@ApiModel(description="Behavior of the paused subscription when it resumes.")
public class ResumeSubscriptionRequest {
    public static final String SERIALIZED_NAME_EXTEND_TERM = "extend_term";
    @SerializedName(value="extend_term")
    private Boolean extendTerm = false;
    public static final String SERIALIZED_NAME_RESUME_DATE = "resume_date";
    @SerializedName(value="resume_date")
    private String resumeDate;
    public static final String SERIALIZED_NAME_RESUME_AT = "resume_at";
    @SerializedName(value="resume_at")
    private ResumeAtEnum resumeAt;
    public static final String SERIALIZED_NAME_CHANGE_REASON = "change_reason";
    @SerializedName(value="change_reason")
    private String changeReason;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;

    public ResumeSubscriptionRequest extendTerm(Boolean extendTerm) {
        this.extendTerm = extendTerm;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this field is set to `true`, the subscription term is extended by the length of time the subscription is paused.")
    public Boolean getExtendTerm() {
        return this.extendTerm;
    }

    public void setExtendTerm(Boolean extendTerm) {
        this.extendTerm = extendTerm;
    }

    public ResumeSubscriptionRequest resumeDate(String resumeDate) {
        this.resumeDate = resumeDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date on which the paused subscription is resumed.")
    public String getResumeDate() {
        return this.resumeDate;
    }

    public void setResumeDate(String resumeDate) {
        this.resumeDate = resumeDate;
    }

    public ResumeSubscriptionRequest resumeAt(ResumeAtEnum resumeAt) {
        this.resumeAt = resumeAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="You can use this field to resume a paused subscription from the pause date.")
    public ResumeAtEnum getResumeAt() {
        return this.resumeAt;
    }

    public void setResumeAt(ResumeAtEnum resumeAt) {
        this.resumeAt = resumeAt;
    }

    public ResumeSubscriptionRequest changeReason(String changeReason) {
        this.changeReason = changeReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A brief description of the reason for this change.")
    public String getChangeReason() {
        return this.changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public ResumeSubscriptionRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public ResumeSubscriptionRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResumeSubscriptionRequest resumeSubscriptionRequest = (ResumeSubscriptionRequest)o;
        return Objects.equals(this.extendTerm, resumeSubscriptionRequest.extendTerm) && Objects.equals(this.resumeDate, resumeSubscriptionRequest.resumeDate) && Objects.equals((Object)this.resumeAt, (Object)resumeSubscriptionRequest.resumeAt) && Objects.equals(this.changeReason, resumeSubscriptionRequest.changeReason) && Objects.equals(this.customFields, resumeSubscriptionRequest.customFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extendTerm, this.resumeDate, this.resumeAt, this.changeReason, this.customFields});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResumeSubscriptionRequest {\n");
        sb.append("    extendTerm: ").append(this.toIndentedString(this.extendTerm)).append("\n");
        sb.append("    resumeDate: ").append(this.toIndentedString(this.resumeDate)).append("\n");
        sb.append("    resumeAt: ").append(this.toIndentedString((Object)this.resumeAt)).append("\n");
        sb.append("    changeReason: ").append(this.toIndentedString(this.changeReason)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResumeAtEnum {
        PAUSE_DATE("pause_date"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private ResumeAtEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResumeAtEnum fromValue(String value) {
            for (ResumeAtEnum b : ResumeAtEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ResumeAtEnum> {
            public void write(JsonWriter jsonWriter, ResumeAtEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResumeAtEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResumeAtEnum.fromValue(value);
            }
        }
    }
}

