/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.openapitools.client.ApiCallback;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.Configuration;
import org.openapitools.client.Pair;
import org.openapitools.client.model.BillRunPreview;
import org.openapitools.client.model.BillRunPreviewCreateRequest;
import org.openapitools.client.model.ErrorResponse;
import org.openapitools.client.model.GetByIdQueryParams;
import org.openapitools.client.model.Headers;

public class BillRunPreviewsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public BillRunPreviewsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public BillRunPreviewsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createBillRunPreviewCall(BillRunPreviewCreateRequest billRunPreviewCreateRequest, List<String> fields, List<String> billRunPreviewFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        BillRunPreviewCreateRequest localVarPostBody = billRunPreviewCreateRequest;
        String localVarPath = "/bill_run_previews";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billRunPreviewFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_run_preview.fields[]", billRunPreviewFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createBillRunPreviewValidateBeforeCall(BillRunPreviewCreateRequest billRunPreviewCreateRequest, List<String> fields, List<String> billRunPreviewFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billRunPreviewCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'billRunPreviewCreateRequest' when calling createBillRunPreview(Async)");
        }
        return this.createBillRunPreviewCall(billRunPreviewCreateRequest, fields, billRunPreviewFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillRunPreview> createBillRunPreviewWithHttpInfo(BillRunPreviewCreateRequest billRunPreviewCreateRequest, List<String> fields, List<String> billRunPreviewFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.createBillRunPreviewValidateBeforeCall(billRunPreviewCreateRequest, fields, billRunPreviewFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillRunPreview>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call createBillRunPreviewAsync(BillRunPreviewCreateRequest billRunPreviewCreateRequest, List<String> fields, List<String> billRunPreviewFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<BillRunPreview> _callback) throws ApiException {
        Call localVarCall = this.createBillRunPreviewValidateBeforeCall(billRunPreviewCreateRequest, fields, billRunPreviewFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillRunPreview>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public CreateBillRunPreviewParams createBillRunPreviewParams(BillRunPreviewCreateRequest billRunPreviewCreateRequest) {
        return new CreateBillRunPreviewParams(billRunPreviewCreateRequest);
    }

    public BillRunPreview createBillRunPreview(BillRunPreviewCreateRequest billRunPreviewCreateRequest) throws ApiException {
        CreateBillRunPreviewParams params = new CreateBillRunPreviewParams(billRunPreviewCreateRequest);
        return this.executeCreateBillRunPreviewAPICall(params).getData();
    }

    public BillRunPreview createBillRunPreview(BillRunPreviewCreateRequest billRunPreviewCreateRequest, List<String> expand) throws ApiException {
        CreateBillRunPreviewParams params = new CreateBillRunPreviewParams(billRunPreviewCreateRequest);
        params.expand(expand);
        return this.executeCreateBillRunPreviewAPICall(params).getData();
    }

    public BillRunPreview createBillRunPreview(BillRunPreviewCreateRequest billRunPreviewCreateRequest, List<String> expand, Headers headers) throws ApiException {
        CreateBillRunPreviewParams params = new CreateBillRunPreviewParams(billRunPreviewCreateRequest).expand(expand).headers(headers);
        return this.executeCreateBillRunPreviewAPICall(params).getData();
    }

    public BillRunPreview createBillRunPreview(CreateBillRunPreviewParams params) throws ApiException {
        return this.executeCreateBillRunPreviewAPICall(params).getData();
    }

    public ApiResponse<BillRunPreview> createBillRunPreviewWithHttpInfo(CreateBillRunPreviewParams params) throws ApiException {
        return this.executeCreateBillRunPreviewAPICall(params);
    }

    ApiResponse<BillRunPreview> executeCreateBillRunPreviewAPICall(CreateBillRunPreviewParams params) throws ApiException {
        return this.createBillRunPreviewWithHttpInfo(params.billRunPreviewCreateRequest, params.fields, params.billRunPreviewFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    private Call getBillRunPreviewCall(String billRunPreviewId, List<String> fields, List<String> billRunPreviewFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/bill_run_previews/{bill_run_preview_id}".replace("{bill_run_preview_id}", this.localVarApiClient.escapeString(billRunPreviewId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "fields[]", fields));
        }
        if (billRunPreviewFields != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "bill_run_preview.fields[]", billRunPreviewFields));
        }
        if (expand != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "expand[]", expand));
        }
        if (filter != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "filter[]", filter));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if (zuoraTrackId != null) {
            localVarHeaderParams.put("zuora-track-id", this.localVarApiClient.parameterToString(zuoraTrackId));
        }
        if (async != null) {
            localVarHeaderParams.put("async", this.localVarApiClient.parameterToString(async));
        }
        if (zuoraCacheEnabled != null) {
            localVarHeaderParams.put("zuora-cache-enabled", this.localVarApiClient.parameterToString(zuoraCacheEnabled));
        }
        if (zuoraEntityIds != null) {
            localVarHeaderParams.put("zuora-entity-ids", this.localVarApiClient.parameterToString(zuoraEntityIds));
        }
        if (idempotencyKey != null) {
            localVarHeaderParams.put("idempotency-key", this.localVarApiClient.parameterToString(idempotencyKey));
        }
        if (acceptEncoding != null) {
            localVarHeaderParams.put("accept-encoding", this.localVarApiClient.parameterToString(acceptEncoding));
        }
        if (contentEncoding != null) {
            localVarHeaderParams.put("content-encoding", this.localVarApiClient.parameterToString(contentEncoding));
        }
        if (zuoraOrgIds != null) {
            localVarHeaderParams.put("zuora-org-ids", this.localVarApiClient.parameterToString(zuoraOrgIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getBillRunPreviewValidateBeforeCall(String billRunPreviewId, List<String> fields, List<String> billRunPreviewFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback _callback) throws ApiException {
        if (billRunPreviewId == null) {
            throw new ApiException("Missing the required parameter 'billRunPreviewId' when calling getBillRunPreview(Async)");
        }
        return this.getBillRunPreviewCall(billRunPreviewId, fields, billRunPreviewFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
    }

    private ApiResponse<BillRunPreview> getBillRunPreviewWithHttpInfo(String billRunPreviewId, List<String> fields, List<String> billRunPreviewFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds) throws ApiException {
        Call localVarCall = this.getBillRunPreviewValidateBeforeCall(billRunPreviewId, fields, billRunPreviewFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, null);
        try {
            Type localVarReturnType = new TypeToken<BillRunPreview>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            e.setErrorObject((ErrorResponse)this.localVarApiClient.getJSON().getGson().fromJson(e.getResponseBody(), new TypeToken<ErrorResponse>(){}.getType()));
            throw e;
        }
    }

    private Call getBillRunPreviewAsync(String billRunPreviewId, List<String> fields, List<String> billRunPreviewFields, List<String> expand, List<String> filter, Integer pageSize, String zuoraTrackId, Boolean async, Boolean zuoraCacheEnabled, String zuoraEntityIds, String idempotencyKey, String acceptEncoding, String contentEncoding, String zuoraOrgIds, ApiCallback<BillRunPreview> _callback) throws ApiException {
        Call localVarCall = this.getBillRunPreviewValidateBeforeCall(billRunPreviewId, fields, billRunPreviewFields, expand, filter, pageSize, zuoraTrackId, async, zuoraCacheEnabled, zuoraEntityIds, idempotencyKey, acceptEncoding, contentEncoding, zuoraOrgIds, _callback);
        Type localVarReturnType = new TypeToken<BillRunPreview>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public GetBillRunPreviewParams getBillRunPreviewParams(String billRunPreviewId) {
        return new GetBillRunPreviewParams(billRunPreviewId);
    }

    public BillRunPreview getBillRunPreview(String billRunPreviewId) throws ApiException {
        GetBillRunPreviewParams params = new GetBillRunPreviewParams(billRunPreviewId);
        return this.executeGetBillRunPreviewAPICall(params).getData();
    }

    public BillRunPreview getBillRunPreview(String billRunPreviewId, List<String> expand) throws ApiException {
        GetBillRunPreviewParams params = new GetBillRunPreviewParams(billRunPreviewId);
        params.expand(expand);
        return this.executeGetBillRunPreviewAPICall(params).getData();
    }

    public BillRunPreview getBillRunPreview(String billRunPreviewId, List<String> expand, Headers headers) throws ApiException {
        GetBillRunPreviewParams params = new GetBillRunPreviewParams(billRunPreviewId).expand(expand).headers(headers);
        return this.executeGetBillRunPreviewAPICall(params).getData();
    }

    public BillRunPreview getBillRunPreview(GetBillRunPreviewParams params) throws ApiException {
        return this.executeGetBillRunPreviewAPICall(params).getData();
    }

    public ApiResponse<BillRunPreview> getBillRunPreviewWithHttpInfo(GetBillRunPreviewParams params) throws ApiException {
        return this.executeGetBillRunPreviewAPICall(params);
    }

    ApiResponse<BillRunPreview> executeGetBillRunPreviewAPICall(GetBillRunPreviewParams params) throws ApiException {
        return this.getBillRunPreviewWithHttpInfo(params.billRunPreviewId, params.fields, params.billRunPreviewFields, params.expand, params.filter, params.pageSize, params.zuoraTrackId, params.async, params.zuoraCacheEnabled, params.zuoraEntityIds, params.idempotencyKey, params.acceptEncoding, params.contentEncoding, params.zuoraOrgIds);
    }

    public static class GetBillRunPreviewParams {
        private final String billRunPreviewId;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> billRunPreviewFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public GetBillRunPreviewParams(String billRunPreviewId) {
            this.billRunPreviewId = billRunPreviewId;
        }

        public GetBillRunPreviewParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public GetBillRunPreviewParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public GetBillRunPreviewParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public GetBillRunPreviewParams billRunPreviewFields(List<String> billRunPreviewFields) {
            this.billRunPreviewFields = billRunPreviewFields;
            return this;
        }

        public GetBillRunPreviewParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public GetBillRunPreviewParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public GetBillRunPreviewParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }

    public static class CreateBillRunPreviewParams {
        private final BillRunPreviewCreateRequest billRunPreviewCreateRequest;
        private Headers headers;
        private GetByIdQueryParams getByIdQueryParams;
        private List<String> fields;
        private List<String> billRunPreviewFields;
        private List<String> expand;
        private List<String> filter;
        private Integer pageSize;
        private String zuoraTrackId;
        private Boolean async;
        private Boolean zuoraCacheEnabled;
        private String zuoraEntityIds;
        private String idempotencyKey;
        private String acceptEncoding;
        private String contentEncoding;
        private String zuoraOrgIds;

        public CreateBillRunPreviewParams(BillRunPreviewCreateRequest billRunPreviewCreateRequest) {
            this.billRunPreviewCreateRequest = billRunPreviewCreateRequest;
        }

        public CreateBillRunPreviewParams getByIdQueryParams(GetByIdQueryParams getByIdQueryParams) {
            this.getByIdQueryParams = getByIdQueryParams;
            if (this.expand != null) {
                this.expand = getByIdQueryParams.getExpand();
            }
            if (this.filter != null) {
                this.filter = getByIdQueryParams.getFilter();
            }
            if (this.pageSize != null) {
                this.pageSize = getByIdQueryParams.getPageSize();
            }
            return this;
        }

        public CreateBillRunPreviewParams headers(Headers headers) {
            this.headers = headers;
            if (headers.getZuoraTrackId() != null) {
                this.zuoraTrackId = headers.getZuoraTrackId();
            }
            if (headers.getAsync() != null) {
                this.async = headers.getAsync();
            }
            if (headers.getZuoraCacheEnabled() != null) {
                this.zuoraCacheEnabled = headers.getZuoraCacheEnabled();
            }
            if (headers.getZuoraEntityIds() != null) {
                this.zuoraEntityIds = headers.getZuoraEntityIds();
            }
            if (headers.getIdempotencyKey() != null) {
                this.idempotencyKey = headers.getIdempotencyKey();
            }
            if (headers.getAcceptEncoding() != null) {
                this.acceptEncoding = headers.getAcceptEncoding();
            }
            if (headers.getContentEncoding() != null) {
                this.contentEncoding = headers.getContentEncoding();
            }
            if (headers.getZuoraOrgIds() != null) {
                this.zuoraOrgIds = headers.getZuoraOrgIds();
            }
            return this;
        }

        public CreateBillRunPreviewParams fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public CreateBillRunPreviewParams billRunPreviewFields(List<String> billRunPreviewFields) {
            this.billRunPreviewFields = billRunPreviewFields;
            return this;
        }

        public CreateBillRunPreviewParams expand(List<String> expand) {
            this.expand = expand;
            return this;
        }

        public CreateBillRunPreviewParams filter(List<String> filter) {
            this.filter = filter;
            return this;
        }

        public CreateBillRunPreviewParams pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }
    }
}

