/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.AccountContactCreateRequest;
import org.openapitools.client.model.TaxCertificate;
import org.openapitools.client.model.TaxIdentifier;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Account data that is used for the subscription preview. If you specify this field, do not specify `account_id`. Note that this operation is only for preview and no subscription is created.")
public class SubscriptionPreviewAccountRequest {
    public static final String SERIALIZED_NAME_SOLD_TO = "sold_to";
    @SerializedName(value="sold_to")
    private AccountContactCreateRequest soldTo;
    public static final String SERIALIZED_NAME_TAX_CERTIFICATE = "tax_certificate";
    @SerializedName(value="tax_certificate")
    private TaxCertificate taxCertificate;
    public static final String SERIALIZED_NAME_BILL_CYCLE_DAY = "bill_cycle_day";
    @SerializedName(value="bill_cycle_day")
    private Integer billCycleDay;
    public static final String SERIALIZED_NAME_CURRENCY = "currency";
    @SerializedName(value="currency")
    private String currency;
    public static final String SERIALIZED_NAME_TAX_IDENTIFIER = "tax_identifier";
    @SerializedName(value="tax_identifier")
    private TaxIdentifier taxIdentifier;
    public static final String SERIALIZED_NAME_CUSTOM_FIELDS = "custom_fields";
    @SerializedName(value="custom_fields")
    @JsonAdapter(value=JSON.CustomFieldAdapter.class)
    private Map<String, String> customFields = null;

    public SubscriptionPreviewAccountRequest soldTo(AccountContactCreateRequest soldTo) {
        this.soldTo = soldTo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Customer address used for calculating tax.")
    public AccountContactCreateRequest getSoldTo() {
        return this.soldTo;
    }

    public void setSoldTo(AccountContactCreateRequest soldTo) {
        this.soldTo = soldTo;
    }

    public SubscriptionPreviewAccountRequest taxCertificate(TaxCertificate taxCertificate) {
        this.taxCertificate = taxCertificate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaxCertificate getTaxCertificate() {
        return this.taxCertificate;
    }

    public void setTaxCertificate(TaxCertificate taxCertificate) {
        this.taxCertificate = taxCertificate;
    }

    public SubscriptionPreviewAccountRequest billCycleDay(Integer billCycleDay) {
        this.billCycleDay = billCycleDay;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The day of the month on which your customer will be invoiced. For month-end specify 31.")
    public Integer getBillCycleDay() {
        return this.billCycleDay;
    }

    public void setBillCycleDay(Integer billCycleDay) {
        this.billCycleDay = billCycleDay;
    }

    public SubscriptionPreviewAccountRequest currency(String currency) {
        this.currency = currency;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="USD", required=true, value="Three-letter ISO currency code. Once the currency is set for an account, it cannot be updated.")
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public SubscriptionPreviewAccountRequest taxIdentifier(TaxIdentifier taxIdentifier) {
        this.taxIdentifier = taxIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TaxIdentifier getTaxIdentifier() {
        return this.taxIdentifier;
    }

    public void setTaxIdentifier(TaxIdentifier taxIdentifier) {
        this.taxIdentifier = taxIdentifier;
    }

    public SubscriptionPreviewAccountRequest customFields(Map<String, String> customFields) {
        this.customFields = customFields;
        return this;
    }

    public SubscriptionPreviewAccountRequest putCustomFieldsItem(String key, String customFieldsItem) {
        if (this.customFields == null) {
            this.customFields = new HashMap<String, String>();
        }
        this.customFields.put(key, customFieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set of user-defined fields associated with this object. Useful for storing additional information about the object in a structured format.")
    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, String> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionPreviewAccountRequest subscriptionPreviewAccountRequest = (SubscriptionPreviewAccountRequest)o;
        return Objects.equals(this.soldTo, subscriptionPreviewAccountRequest.soldTo) && Objects.equals(this.taxCertificate, subscriptionPreviewAccountRequest.taxCertificate) && Objects.equals(this.billCycleDay, subscriptionPreviewAccountRequest.billCycleDay) && Objects.equals(this.currency, subscriptionPreviewAccountRequest.currency) && Objects.equals(this.taxIdentifier, subscriptionPreviewAccountRequest.taxIdentifier) && Objects.equals(this.customFields, subscriptionPreviewAccountRequest.customFields);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.soldTo, this.taxCertificate, this.billCycleDay, this.currency, this.taxIdentifier, this.customFields);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionPreviewAccountRequest {\n");
        sb.append("    soldTo: ").append(this.toIndentedString(this.soldTo)).append("\n");
        sb.append("    taxCertificate: ").append(this.toIndentedString(this.taxCertificate)).append("\n");
        sb.append("    billCycleDay: ").append(this.toIndentedString(this.billCycleDay)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    taxIdentifier: ").append(this.toIndentedString(this.taxIdentifier)).append("\n");
        sb.append("    customFields: ").append(this.toIndentedString(this.customFields)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

