/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="If it is a `paypal_adaptive` payment method, this hash contains details about the PayPal Adaptive payment method.")
public class PaypalAdaptive {
    public static final String SERIALIZED_NAME_PREAPPROVAL_KEY = "preapproval_key";
    @SerializedName(value="preapproval_key")
    private String preapprovalKey;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;

    public PaypalAdaptive preapprovalKey(String preapprovalKey) {
        this.preapprovalKey = preapprovalKey;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2G4EPFSD", required=true, value="PayPal preapproval key.")
    public String getPreapprovalKey() {
        return this.preapprovalKey;
    }

    public void setPreapprovalKey(String preapprovalKey) {
        this.preapprovalKey = preapprovalKey;
    }

    public PaypalAdaptive email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="alawrence@zuora.com", required=true, value="Email address associated with the payment method.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaypalAdaptive paypalAdaptive = (PaypalAdaptive)o;
        return Objects.equals(this.preapprovalKey, paypalAdaptive.preapprovalKey) && Objects.equals(this.email, paypalAdaptive.email);
    }

    public int hashCode() {
        return Objects.hash(this.preapprovalKey, this.email);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaypalAdaptive {\n");
        sb.append("    preapprovalKey: ").append(this.toIndentedString(this.preapprovalKey)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

